/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

public final class Scale {
    public static final double SCALE;
    public static final double SCALE_X;
    public static final double SCALE_Y;
    private static final double EPSILON = 1.0E-4;

    public static double scaleWidth(double value, GraphicsConfiguration gc) {
        if (gc == null) {
            return Scale.scaleWidth(value);
        }
        AffineTransform transform = gc.getDefaultTransform();
        return transform.getScaleX() * value;
    }

    public static double scaleHeight(double value, GraphicsConfiguration gc) {
        if (gc == null) {
            return Scale.scaleHeight(value);
        }
        AffineTransform transform = gc.getDefaultTransform();
        return transform.getScaleY() * value;
    }

    public static double inverseScaleWidth(double value, GraphicsConfiguration gc) {
        if (gc == null) {
            return Scale.inverseScaleWidth(value);
        }
        AffineTransform transform = gc.getDefaultTransform();
        return 1.0 / transform.getScaleX() * value;
    }

    public static double inverseScaleHeight(double value, GraphicsConfiguration gc) {
        if (gc == null) {
            return Scale.inverseScaleHeight(value);
        }
        AffineTransform transform = gc.getDefaultTransform();
        return 1.0 / transform.getScaleY() * value;
    }

    public static int scaleWidth(int i) {
        return (int)(SCALE_X * (double)i);
    }

    public static float scaleWidth(float f) {
        return (float)(SCALE_X * (double)f);
    }

    public static double scaleWidth(double d) {
        return SCALE_X * d;
    }

    public static int inverseScaleWidth(int i) {
        return (int)(1.0 / SCALE_X * (double)i);
    }

    public static float inverseScaleWidth(float f) {
        return (float)(1.0 / SCALE_X * (double)f);
    }

    public static double inverseScaleWidth(double d) {
        return 1.0 / SCALE_X * d;
    }

    public static int scaleHeight(int i) {
        return (int)(SCALE_Y * (double)i);
    }

    public static float scaleHeight(float f) {
        return (float)(SCALE_Y * (double)f);
    }

    public static double scaleHeight(double d) {
        return SCALE_Y * d;
    }

    public static int inverseScaleHeight(int i) {
        return (int)(1.0 / SCALE_Y * (double)i);
    }

    public static float inverseScaleHeight(float f) {
        return (float)(1.0 / SCALE_Y * (double)f);
    }

    public static double inverseScaleHeight(double d) {
        return 1.0 / SCALE_Y * d;
    }

    public static double getScaleX(Graphics2D g) {
        return g.getTransform().getScaleX();
    }

    public static double getScaleY(Graphics2D g) {
        return g.getTransform().getScaleY();
    }

    public static double getScaleX(GraphicsConfiguration gc) {
        if (gc == null) {
            return SCALE_X;
        }
        return gc.getDefaultTransform().getScaleX();
    }

    public static double getScaleY(GraphicsConfiguration gc) {
        if (gc == null) {
            return SCALE_Y;
        }
        return gc.getDefaultTransform().getScaleY();
    }

    public static Dimension scale(GraphicsConfiguration gc, Dimension size) {
        return new Dimension((int)Scale.scaleWidth(size.width, gc), (int)Scale.scaleHeight(size.height, gc));
    }

    public static Point scale(GraphicsConfiguration gc, Point p) {
        return new Point((int)Scale.scaleWidth(p.x, gc), (int)Scale.scaleHeight(p.y, gc));
    }

    public static Dimension inverseScale(GraphicsConfiguration gc, Dimension size) {
        return new Dimension((int)Scale.inverseScaleWidth(size.width, gc), (int)Scale.inverseScaleHeight(size.height, gc));
    }

    public static Point inverseScale(GraphicsConfiguration gc, Point p) {
        try {
            return (Point)gc.getDefaultTransform().inverseTransform(p, p);
        }
        catch (NoninvertibleTransformException e) {
            return p;
        }
    }

    public static double scale(double scale, double value) {
        return scale * value;
    }

    public static Dimension scale(double scaleX, double scaleY, Dimension size) {
        return new Dimension((int)Scale.scale(scaleX, size.width), (int)Scale.scale(scaleY, size.height));
    }

    public static boolean equalWithError(double a, double b) {
        return Math.abs(a - b) < 1.0E-4;
    }

    static {
        if (GraphicsEnvironment.isHeadless()) {
            SCALE = 1.0;
            SCALE_X = 1.0;
            SCALE_Y = 1.0;
        } else {
            DisplayMode mode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            SCALE_X = (double)mode.getWidth() / (double)screenSize.width;
            SCALE_Y = (double)mode.getHeight() / (double)screenSize.height;
            SCALE = SCALE_X;
        }
    }
}

