/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.browserprefui;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.browserprefui.BrowserPrefDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class BrowserPrefAction
extends AbstractAction {
    private final BrowserLauncher browserLauncher;
    private final JFrame appFrame;

    public BrowserPrefAction(String name, BrowserLauncher browserLauncher, JFrame appFrame) {
        super(name);
        if (browserLauncher == null) {
            throw new IllegalArgumentException("browserLauncher cannot be null");
        }
        this.browserLauncher = browserLauncher;
        this.appFrame = appFrame;
    }

    public BrowserPrefAction(String name, Icon icon, BrowserLauncher browserLauncher, JFrame appFrame) {
        super(name, icon);
        if (browserLauncher == null) {
            throw new IllegalArgumentException("browserLauncher cannot be null");
        }
        this.browserLauncher = browserLauncher;
        this.appFrame = appFrame;
    }

    public void actionPerformed(ActionEvent e) {
        ActionEvent event = e;
        Runnable runner = new Runnable(){

            public void run() {
                try {
                    BrowserPrefDialog dlg = new BrowserPrefDialog((Frame)BrowserPrefAction.this.appFrame, BrowserPrefAction.this.browserLauncher);
                    dlg.setLocationRelativeTo(BrowserPrefAction.this.appFrame);
                    dlg.pack();
                    dlg.setSize(275, 200);
                    dlg.setVisible(true);
                    String prefBrowser = dlg.getSelectedBrowser();
                    if (prefBrowser != null) {
                        System.setProperty("edu.stanford.ejalbert.preferred.browser", prefBrowser);
                    }
                }
                catch (Exception ex) {
                    BrowserPrefAction.this.browserLauncher.getLogger().error("problem getting/setting browser pref", ex);
                }
            }
        };
        SwingUtilities.invokeLater(runner);
    }
}

