/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Download;
import de.haukerehfeld.quakeinjector.FileInfo;
import de.haukerehfeld.quakeinjector.InstalledPackageList;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.ProgressListener;
import de.haukerehfeld.quakeinjector.QuakeInjector;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.RequirementList;
import de.haukerehfeld.quakeinjector.SaveInstalled;
import de.haukerehfeld.quakeinjector.UnavailableRequirement;
import de.haukerehfeld.quakeinjector.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;

class CheckInstalled
extends SwingWorker<List<PackageFileList>, Void>
implements ProgressListener {
    String zipContentsDatabaseUrl;
    String enginePath;
    RequirementList maps;
    SaveInstalled saveInstalled;
    QuakeInjector injector;

    public CheckInstalled(QuakeInjector injector, String zipContentsDatabaseUrl, String enginePath, RequirementList maps, SaveInstalled saveInstalled) {
        this.zipContentsDatabaseUrl = zipContentsDatabaseUrl;
        this.enginePath = enginePath;
        this.maps = maps;
        this.injector = injector;
        this.saveInstalled = saveInstalled;
    }

    @Override
    public List<PackageFileList> doInBackground() throws InterruptedException, ExecutionException, IOException {
        List<Object> packages = Collections.emptyList();
        Download d = Download.create(this.zipContentsDatabaseUrl);
        d.connect();
        InputStream dl = d.getStream();
        try {
            packages = new InstalledPackageList().read(dl);
            Collections.sort(packages);
        }
        catch (FileNotFoundException e) {
            System.out.println("Notice: installed maps file doesn't exist yet, no maps installed? " + e);
        }
        catch (IOException e) {
            System.err.println("Error: installed maps file couldn't be loaded: " + e);
            e.printStackTrace();
        }
        int i = 0;
        ArrayList<PackageFileList> installed = new ArrayList<PackageFileList>();
        for (PackageFileList packageFileList : packages) {
            this.publish(i++ * 100 / packages.size());
            Requirement r = this.maps.get(packageFileList.getId());
            String basedir = this.enginePath + File.separator;
            if (r instanceof UnavailableRequirement) continue;
            ArrayList<CallSite> missingFiles = new ArrayList<CallSite>();
            for (FileInfo entry : packageFileList) {
                if (this.isCancelled()) {
                    throw new CancellationException();
                }
                if (packageFileList.size() > 7 && (float)missingFiles.size() > 0.2f * (float)packageFileList.size()) {
                    System.out.println("Too many missing files for " + packageFileList.getId() + ", stopping search!");
                    break;
                }
                String filename = entry.getName();
                String file = basedir + filename;
                long supposedCrc = entry.getChecksum();
                File f = new File(file);
                System.out.print("Checking for " + f + "...");
                if (!f.exists()) {
                    if (!entry.getEssential()) continue;
                    missingFiles.add((CallSite)((Object)file));
                    System.out.println("missing!");
                    continue;
                }
                System.out.println("found!");
                if (f.isDirectory()) continue;
                long crc = Utils.getCrc32(new BufferedInputStream(new FileInputStream(f)), null);
                if (supposedCrc == 0L || crc == entry.getChecksum()) continue;
                System.err.println("Crc differs for file " + file);
                if (!entry.getEssential()) continue;
                System.out.println("Counting as missing.");
                missingFiles.add((CallSite)((Object)file));
            }
            if (missingFiles.isEmpty()) {
                System.out.println(packageFileList.getId() + " seems to be installed.");
                installed.add(packageFileList);
                continue;
            }
            System.out.println(packageFileList.getId() + " has missing files, not installed.");
        }
        return installed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() {
        try {
            List list = (List)this.get();
            this.injector.setInstalledStatus(list);
            RequirementList requirementList = this.maps;
            synchronized (requirementList) {
                this.saveInstalled.write(this.maps);
            }
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted: " + e);
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            System.err.println("Exception: " + e);
            e.printStackTrace();
            try {
                throw e.getCause();
            }
            catch (ConnectException err) {
                String msg = "Downloading file database failed, " + err.getMessage() + "!";
                JOptionPane.showMessageDialog(this.injector, msg, "Downloading failed!", 0);
            }
            finally {
            }
        }
        catch (CancellationException e) {
        }
        catch (IOException e) {
            System.err.println("Couldn't write installedMapsFile: " + e);
            e.printStackTrace();
        }
    }

    @Override
    public void publish(long progress) {
        if (progress <= 100L) {
            this.setProgress((int)progress);
        }
    }
}

