/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.BuildCommit;
import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.Utils;
import de.haukerehfeld.quakeinjector.gui.UIThemeOption;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeListener;

public class Configuration {
    private static final String CONFIGHEADER = "Quake Injector " + BuildCommit.getBuildCommit() + " config file";
    public final EnginePath EnginePath = new EnginePath();
    public final EngineExecutable EngineExecutable = new EngineExecutable();
    public final WorkingDirAtExecutable WorkingDirAtExecutable = new WorkingDirAtExecutable();
    public final LocalDatabaseFile LocalDatabaseFile = new LocalDatabaseFile();
    public final DownloadPath DownloadPath = new DownloadPath();
    public final EngineCommandLine EngineCommandLine = new EngineCommandLine();
    public final RepositoryDatabasePath RepositoryDatabasePath = new RepositoryDatabasePath();
    public final ScreenshotRepositoryPath ScreenshotRepositoryPath = new ScreenshotRepositoryPath();
    public final ZipContentsDatabaseUrl ZipContentsDatabaseUrl = new ZipContentsDatabaseUrl();
    public final RogueInstalled RogueInstalled = new RogueInstalled();
    public final OfflineMode OfflineMode = new OfflineMode();
    public final HipnoticInstalled HipnoticInstalled = new HipnoticInstalled();
    public final MainWindowPositionX MainWindowPositionX = new MainWindowPositionX();
    public final MainWindowPositionY MainWindowPositionY = new MainWindowPositionY();
    public final MainWindowWidth MainWindowWidth = new MainWindowWidth();
    public final MainWindowHeight MainWindowHeight = new MainWindowHeight();
    public final MainWindowState MainWindowState = new MainWindowState();
    public final RepositoryBasePath RepositoryBasePath = new RepositoryBasePath();
    public final MapWebpageBaseUrl mapWebpageBaseUrl = new MapWebpageBaseUrl();
    public final UIThemeConfiguration uiTheme = new UIThemeConfiguration();
    public final Map<String, Value<?>> All = new HashMap();
    private File configFile;

    public Configuration(File configFile) {
        Field[] fields;
        this.configFile = configFile;
        for (Field f : fields = this.getClass().getDeclaredFields()) {
            if (!Value.class.isAssignableFrom(f.getType())) continue;
            try {
                this.All.put(f.getName(), (Value)f.get(this));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.init();
    }

    private void set(Configuration c) {
        for (Map.Entry<String, Value<?>> e : c.All.entrySet()) {
            String key = e.getKey();
            Value<?> v = e.getValue();
            if (v.equals(this.getValue(key))) continue;
            this.getValue(key).set(v.get());
        }
    }

    private Value getValue(String key) {
        return this.All.get(key);
    }

    public void init() {
        this.read();
    }

    private void read() {
        System.out.println("Reading configuration...");
        Properties properties = new Properties(this.defaults());
        if (this.configFile.canRead()) {
            try {
                FileInputStream in = new FileInputStream(this.configFile);
                properties.load(in);
                in.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("Can't read config file (" + e.getMessage() + ") even though i just checked if i can read it. Using defaults...");
            }
            catch (IOException e) {
                System.out.println("Couldn't read config file: " + e.getMessage() + ". Using defaults...");
            }
        }
        this.set(properties);
    }

    public void set(Properties p) {
        for (String key : this.All.keySet()) {
            String s = p.getProperty(key);
            if (s == null) continue;
            Value<?> v = this.All.get(key);
            v.set(v.stringToValue(s));
        }
    }

    public void get(Properties p) {
        for (String key : this.All.keySet()) {
            Value<?> v = this.All.get(key);
            if (v.exists()) {
                p.setProperty(key, v.toString());
                continue;
            }
            if (p.getProperty(key) == null) continue;
            p.remove(key);
        }
    }

    public void write() throws IOException {
        if (!Utils.canWriteToDirectory(this.configFile.getParentFile())) {
            System.out.println("Cannot write to config directory!");
            throw new FileNotFoundException("Cannot write to config directory");
        }
        System.out.print("Writing configuration...");
        try {
            Properties properties = new Properties(this.defaults());
            this.get(properties);
            FileOutputStream out = new FileOutputStream(this.configFile);
            properties.store(out, CONFIGHEADER);
            out.close();
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't write config file: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.err.println("Can't write config file: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("done.");
    }

    private Properties defaults() {
        Properties defaults = new Properties();
        for (String key : this.All.keySet()) {
            Value<?> v = this.All.get(key);
            Object value = v.defaultValue();
            if (value == null) continue;
            defaults.setProperty(v.key(), v.toString());
        }
        return defaults;
    }

    public static class EnginePath
    extends FileValue {
        private EnginePath() {
            super("enginePath", null);
        }

        public File getUnzipFile(Package map, String entryName) {
            String relativePath = map.getExtractMapping().remap(entryName);
            String baseDir = ((File)this.get()).getAbsolutePath();
            if (relativePath != null) {
                return new File(baseDir + File.separator + relativePath);
            }
            return null;
        }
    }

    public static class EngineExecutable
    extends FileValue {
        private EngineExecutable() {
            super("engineExecutable", new File(""));
        }
    }

    public static class WorkingDirAtExecutable
    extends BooleanValue {
        private WorkingDirAtExecutable() {
            super("workingDirAtExecutable", false);
        }
    }

    public static class LocalDatabaseFile
    extends FileValue {
        private LocalDatabaseFile() {
            super("localDatabaseFile", new File("database.json"));
        }
    }

    public class DownloadPath
    extends FileValue {
        private DownloadPath() {
            super("downloadPath", null);
        }

        @Override
        public File get() {
            File result = (File)super.get();
            if (result == null) {
                System.out.println("downloadpath null, returning default");
                return this.defaultPath();
            }
            return result;
        }

        private File defaultPath() {
            if (Configuration.this.EnginePath.get() == null) {
                return null;
            }
            return new File(Configuration.this.EnginePath.get() + File.separator + "downloads");
        }

        @Override
        public void set(File v) {
            System.out.println("Setting downloadpath: " + v);
            if (v.equals(this.defaultPath()) || v.equals(new File(""))) {
                System.out.println(this.getClass() + " Setting downloadpath to null");
                super.set(null);
                return;
            }
            super.set(v);
        }
    }

    public static class EngineCommandLine
    extends StringValue {
        private EngineCommandLine() {
            super("engineCommandline", "");
        }
    }

    public static class RepositoryDatabasePath
    extends StringValue {
        private RepositoryDatabasePath() {
            super("repositoryDatabase", "https://www.quaddicted.com/api/v1/?q=*");
        }
    }

    public static class ScreenshotRepositoryPath
    extends StringValue {
        private ScreenshotRepositoryPath() {
            super("screenshotRepositoryPath", "https://www.quaddicted.com/files/quaddicted-images/by-sha256/");
        }
    }

    public static class ZipContentsDatabaseUrl
    extends StringValue {
        private ZipContentsDatabaseUrl() {
            super("ZipContentsDatabaseUrl", "http://haukerehfeld.de/projects/quakeinjector/temp/zipContents.xml");
        }
    }

    public static class RogueInstalled
    extends BooleanValue {
        private RogueInstalled() {
            super("rogueInstalled", false);
        }
    }

    public static class OfflineMode
    extends BooleanValue {
        private ChangeListenerList listeners = new ChangeListenerList();

        private OfflineMode() {
            super("offlineMode", false);
        }

        public void addChangeListener(ChangeListener l) {
            this.listeners.addChangeListener(l);
        }

        @Override
        public void set(Boolean b) {
            super.set(b);
            this.listeners.notifyChangeListeners(this);
        }
    }

    public static class HipnoticInstalled
    extends BooleanValue {
        private HipnoticInstalled() {
            super("hipnoticInstalled", false);
        }
    }

    public static class MainWindowPositionX
    extends IntegerValue {
        private MainWindowPositionX() {
            super("mainWindowPositionX", null);
        }
    }

    public static class MainWindowPositionY
    extends IntegerValue {
        private MainWindowPositionY() {
            super("mainWindowPositionY", null);
        }
    }

    public static class MainWindowWidth
    extends IntegerValue {
        private MainWindowWidth() {
            super("mainWindowWidth", null);
        }
    }

    public class MainWindowHeight
    extends IntegerValue {
        private MainWindowHeight() {
            super("mainWindowHeight", null);
        }
    }

    public class MainWindowState
    extends IntegerValue {
        private MainWindowState() {
            super("mainWindowState", null);
        }
    }

    public static class RepositoryBasePath
    extends StringValue {
        private static final String onlineRepositoryExtension = ".zip";

        private RepositoryBasePath() {
            super("repositoryBase", "https://www.quaddicted.com/files/by-sha256/");
        }

        public String getRepositoryUrl(String filename, String sha256) {
            return (String)this.get() + sha256.substring(0, 2) + "/" + sha256 + "/" + filename;
        }
    }

    public static class MapWebpageBaseUrl
    extends StringValue {
        private MapWebpageBaseUrl() {
            super("mapWebpageBaseUrl", "https://www.quaddicted.com/db/v1/maps/");
        }
    }

    public static class UIThemeConfiguration
    extends AbstractValue<UIThemeOption> {
        private UIThemeConfiguration() {
            super("uiTheme", UIThemeOption.SYSTEM);
        }

        @Override
        public UIThemeOption stringToValue(String v) {
            return UIThemeOption.getByCode(v);
        }

        @Override
        public String toString() {
            return ((UIThemeOption)((Object)this.get())).getCode();
        }
    }

    public static interface Value<T> {
        public T get();

        public void set(T var1);

        public String key();

        public T defaultValue();

        public T stringToValue(String var1);

        public boolean exists();

        public boolean existsOrDefault();
    }

    public static abstract class IntegerValue
    extends AbstractValue<Integer> {
        protected IntegerValue(String key, Integer defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public Integer stringToValue(String v) {
            if (v == null) {
                return null;
            }
            try {
                return Integer.valueOf(v);
            }
            catch (NumberFormatException e) {
                System.err.println(e);
                e.printStackTrace();
                return null;
            }
        }
    }

    public static abstract class BooleanValue
    extends AbstractValue<Boolean> {
        protected BooleanValue(String key, boolean defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public Boolean stringToValue(String v) {
            return Boolean.valueOf(v);
        }
    }

    public static abstract class FileValue
    extends AbstractValue<File> {
        protected FileValue(String key, File defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public File stringToValue(String v) {
            return new File(v);
        }
    }

    public static abstract class StringValue
    extends AbstractValue<String> {
        protected StringValue(String key, String defaultValue) {
            super(key, defaultValue);
        }

        @Override
        public String stringToValue(String v) {
            return v;
        }

        @Override
        public String toString() {
            return (String)this.get();
        }
    }

    public static abstract class AbstractValue<T>
    implements Value<T> {
        private String key;
        private T defaultValue;
        private T value;

        protected AbstractValue(String key, T defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public abstract T stringToValue(String var1);

        @Override
        public String key() {
            return this.key;
        }

        @Override
        public T defaultValue() {
            return this.defaultValue;
        }

        @Override
        public boolean existsOrDefault() {
            return this.exists() || this.defaultValue != null;
        }

        @Override
        public T get() {
            if (this.value == null) {
                return this.defaultValue;
            }
            return this.value;
        }

        @Override
        public void set(T v) {
            if (v == null || v.equals(this.defaultValue())) {
                this.value = null;
                return;
            }
            this.value = v;
        }

        @Override
        public boolean exists() {
            return this.value != null;
        }

        public String toString() {
            return this.existsOrDefault() ? this.get().toString() : null;
        }
    }
}

