/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.BuildCommit;
import de.haukerehfeld.quakeinjector.HTTPException;
import de.haukerehfeld.quakeinjector.OnlineFileNotFoundException;
import de.haukerehfeld.quakeinjector.ProgressListener;
import de.haukerehfeld.quakeinjector.ProgressListenerInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class Download {
    private final URL url;
    private InputStream stream;
    private URLConnection connection;

    public static Download create(String urlString) throws IOException {
        URL cleanUrl;
        try {
            URL url = new URL(urlString);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            cleanUrl = new URL(uri.toASCIIString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Something is wrong with the way we construct URLs: " + e.getMessage());
        }
        return new Download(cleanUrl);
    }

    public Download(URL url) throws IOException {
        this.url = url;
    }

    public void connect() throws IOException {
        try {
            int response;
            this.connection = this.url.openConnection();
            HttpURLConnection con = null;
            if (this.connection instanceof HttpURLConnection) {
                con = (HttpURLConnection)this.connection;
                HttpURLConnection.setFollowRedirects(true);
                con.setRequestProperty("Accept-Encoding", "gzip, deflate");
                con.setRequestProperty("User-Agent", "Quakeinjector-" + BuildCommit.getBuildCommit());
            }
            this.connection.connect();
            if (con != null && (response = con.getResponseCode()) != 200) {
                throw new HTTPException(response);
            }
            this.connection.getInputStream();
        }
        catch (FileNotFoundException e) {
            throw new OnlineFileNotFoundException(e.getMessage());
        }
    }

    public InputStream getStream() throws IOException {
        return this.getStream(null);
    }

    public InputStream getStream(ProgressListener progress) throws IOException {
        if (this.stream == null) {
            String encoding = this.connection.getContentEncoding();
            this.stream = this.connection.getInputStream();
            if (progress != null) {
                this.stream = new ProgressListenerInputStream(this.stream, progress);
            }
            if (encoding != null && encoding.equalsIgnoreCase("gzip")) {
                this.stream = new GZIPInputStream(this.stream);
            } else if (encoding != null && encoding.equalsIgnoreCase("deflate")) {
                this.stream = new InflaterInputStream(this.stream, new Inflater(true));
            }
        }
        return this.stream;
    }

    public int getSize() {
        return this.connection.getContentLength();
    }

    public String toString() {
        return "<" + this.url.toString() + ">";
    }
}

