/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Cancelable;
import de.haukerehfeld.quakeinjector.CheckCanceledProgressListener;
import de.haukerehfeld.quakeinjector.Download;
import de.haukerehfeld.quakeinjector.Installer;
import de.haukerehfeld.quakeinjector.PercentageProgressListener;
import de.haukerehfeld.quakeinjector.ProgressListener;
import de.haukerehfeld.quakeinjector.SumProgressListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.SwingWorker;

public class DownloadWorker
extends SwingWorker<Long, Void>
implements ProgressListener,
Cancelable {
    private static final int BUFFERSIZE = 1024;
    private final Download download;
    private final OutputStream out;

    public DownloadWorker(Download download, OutputStream out) {
        this.download = download;
        this.out = out;
    }

    @Override
    public Long doInBackground() throws IOException, FileNotFoundException, Installer.CancelledException {
        int readcount;
        System.out.println("Downloading " + this.download);
        this.download.connect();
        SumProgressListener progress = new SumProgressListener(new PercentageProgressListener(this.download.getSize(), new CheckCanceledProgressListener(this, this)));
        InputStream in = this.download.getStream();
        byte[] data = new byte[1024];
        long downloadSize = 0L;
        while ((readcount = in.read(data, 0, 1024)) != -1) {
            progress.publish(readcount);
            this.out.write(data, 0, readcount);
            downloadSize += (long)readcount;
        }
        this.out.flush();
        return downloadSize;
    }

    @Override
    public void publish(long progress) {
        if (progress <= 100L) {
            this.setProgress((int)progress);
        }
    }

    @Override
    public void checkCancelled() throws Installer.CancelledException {
        if (this.isCancelled()) {
            System.out.println("canceling...");
            throw new Installer.CancelledException();
        }
    }
}

