/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.Configuration;
import de.haukerehfeld.quakeinjector.EngineStarter;
import de.haukerehfeld.quakeinjector.gui.ErrorEvent;
import de.haukerehfeld.quakeinjector.gui.ErrorListener;
import de.haukerehfeld.quakeinjector.gui.JPathPanel;
import de.haukerehfeld.quakeinjector.gui.LookAndFeelDefaults;
import de.haukerehfeld.quakeinjector.gui.OkayCancelApplyPanel;
import de.haukerehfeld.quakeinjector.gui.UIThemeOption;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EngineConfigDialog
extends JDialog {
    private static final String windowTitle = "Settings";
    private final ChangeListenerList listeners = new ChangeListenerList();
    private final JPanel configPanel = new JPanel();
    private final JPanel appearancePanel;
    private final JPathPanel enginePath;
    private final JPathPanel engineExecutable;
    private final JTextField engineCommandline;
    private final JPathPanel downloadPath;
    private final JCheckBox rogue;
    private final JCheckBox hipnotic;
    private final WorkingDirOpts workingDirOpts;
    private final JComboBox<UIThemeOption> uiTheme;

    public EngineConfigDialog(JFrame frame, Configuration.EnginePath enginePathDefault, Configuration.EngineExecutable engineExeDefault, Configuration.WorkingDirAtExecutable workingDirAtExecutable, Configuration.DownloadPath downloadPathDefault, Configuration.EngineCommandLine cmdlineDefault, Configuration.RogueInstalled rogueInstalled, Configuration.HipnoticInstalled hipnoticInstalled, Configuration.UIThemeConfiguration uiThemeConfiguration) {
        super(frame, windowTitle, true);
        this.configPanel.setBorder(LookAndFeelDefaults.PADDINGBORDER);
        this.configPanel.setLayout(new GridBagLayout());
        JLabel description = new JLabel("Configure engine specific settings");
        description.setLabelFor(this);
        description.setBorder(LookAndFeelDefaults.DIALOGDESCRIPTIONBORDER);
        this.configPanel.add((Component)description, new GridBagConstraints());
        final JButton okay = new JButton("Okay");
        JButton cancel = new JButton("Cancel");
        final JButton apply = new JButton("Apply");
        int row = 1;
        Border leftBorder = BorderFactory.createEmptyBorder(0, 0, 0, 7);
        JLabel cmdlineLabel = new JLabel("Quake commandline options");
        cmdlineLabel.setBorder(leftBorder);
        this.engineCommandline = new JTextField((String)cmdlineDefault.get(), 40);
        final int row_ = row++;
        class LabelConstraints
        extends GridBagConstraints {
            LabelConstraints() {
                this.anchor = 21;
                this.fill = 0;
                this.gridx = 0;
                this.gridwidth = 1;
                this.gridheight = 1;
                this.weightx = 0.0;
                this.weighty = 0.0;
            }
        }
        this.configPanel.add((Component)cmdlineLabel, new LabelConstraints(){
            {
                this.gridy = row_;
            }
        });
        class InputConstraints
        extends GridBagConstraints {
            InputConstraints() {
                this.anchor = 22;
                this.fill = 2;
                this.gridx = 1;
                this.gridwidth = 2;
                this.gridheight = 1;
                this.weightx = 1.0;
                this.weighty = 0.0;
            }
        }
        this.configPanel.add((Component)this.engineCommandline, new InputConstraints(){
            {
                this.gridy = row_;
            }
        });
        JLabel enginePathLabel = new JLabel("Quake Directory");
        enginePathLabel.setBorder(leftBorder);
        this.enginePath = new JPathPanel(new JPathPanel.WritableDirectoryVerifier(), (File)enginePathDefault.get(), 1);
        row_ = row++;
        this.configPanel.add((Component)enginePathLabel, new LabelConstraints(){
            {
                this.gridy = row_;
            }
        });
        this.configPanel.add((Component)this.enginePath, new InputConstraints(){
            {
                this.gridy = row_;
            }
        });
        JLabel engineExeLabel = new JLabel("Quake Executable");
        engineExeLabel.setBorder(leftBorder);
        this.engineExecutable = new JPathPanel(new JPathPanel.Verifier(){

            @Override
            public boolean verify(File exe) {
                return EngineStarter.isValidApplication(exe);
            }

            @Override
            public String errorMessage(File f) {
                return EngineStarter.errorMessageForApplication(f);
            }
        }, (File)engineExeDefault.get(), (File)enginePathDefault.get(), 0);
        row_ = row++;
        this.configPanel.add((Component)engineExeLabel, new LabelConstraints(){
            {
                this.gridy = row_;
            }
        });
        this.configPanel.add((Component)this.engineExecutable, new InputConstraints(){
            {
                this.gridy = row_;
            }
        });
        this.enginePath.verify();
        this.engineExecutable.verify();
        JLabel downloadLabel = new JLabel("Download Directory");
        downloadLabel.setBorder(leftBorder);
        this.downloadPath = new JPathPanel(new JPathPanel.WritableDirectoryVerifier(), downloadPathDefault.get(), 1);
        this.downloadPath.verify();
        final int row_2 = row++;
        this.configPanel.add((Component)downloadLabel, new LabelConstraints(){
            {
                this.gridy = row_2;
            }
        });
        this.configPanel.add((Component)this.downloadPath, new InputConstraints(){
            {
                this.gridy = row_2;
            }
        });
        JLabel expansionsInstalled = new JLabel("Expansion packs installed");
        expansionsInstalled.setBorder(leftBorder);
        this.rogue = new JCheckBox("rogue");
        this.rogue.setMnemonic(82);
        this.rogue.setSelected((Boolean)rogueInstalled.get());
        this.hipnotic = new JCheckBox("hipnotic");
        this.hipnotic.setMnemonic(72);
        this.hipnotic.setSelected((Boolean)hipnoticInstalled.get());
        row_2 = row++;
        this.configPanel.add((Component)expansionsInstalled, new LabelConstraints(){
            {
                this.gridy = row_2;
            }
        });
        this.configPanel.add((Component)this.rogue, new InputConstraints(){
            {
                this.gridy = row_2;
                this.gridwidth = 1;
            }
        });
        this.configPanel.add((Component)this.hipnotic, new InputConstraints(){
            {
                this.gridy = row_2;
                this.gridx = 2;
                this.gridwidth = 1;
            }
        });
        this.workingDirOpts = new WorkingDirOpts(row, (Boolean)workingDirAtExecutable.get());
        this.appearancePanel = new JPanel();
        this.appearancePanel.setBorder(LookAndFeelDefaults.PADDINGBORDER);
        this.appearancePanel.setLayout(new GridBagLayout());
        JLabel themeLabel = new JLabel("Theme");
        this.uiTheme = new JComboBox<UIThemeOption>(UIThemeOption.values());
        this.uiTheme.setSelectedItem(uiThemeConfiguration.get());
        this.appearancePanel.add((Component)themeLabel, new LabelConstraints(){
            {
                this.gridy = 1;
                this.ipadx = 10;
            }
        });
        this.appearancePanel.add(this.uiTheme, new InputConstraints(){
            {
                this.gridy = 1;
            }
        });
        JLabel restartAdviceLabel = new JLabel("Restart Quake Injector to apply changes");
        this.appearancePanel.add((Component)restartAdviceLabel, new GridBagConstraints(){
            {
                this.gridwidth = 3;
                this.ipady = 10;
                this.gridy = 2;
            }
        });
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBorder(LookAndFeelDefaults.PADDINGBORDER);
        tabbedPane.addTab("Engine Specifics", null, this.configPanel, "Configure Engine Specifics");
        tabbedPane.addTab("Appearance", null, this.appearancePanel, "Appearance");
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.setMnemonicAt(1, 50);
        this.add((Component)tabbedPane, "Center");
        class EnableOkay
        implements ChangeListener,
        DocumentListener {
            EnableOkay() {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.check();
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                this.check();
            }

            private void check() {
                if (EngineConfigDialog.this.enginePath.verifies() && EngineConfigDialog.this.engineExecutable.verifies()) {
                    okay.setEnabled(true);
                    apply.setEnabled(true);
                }
            }
        }
        EnableOkay enableOkay = new EnableOkay();
        this.engineCommandline.getDocument().addDocumentListener(enableOkay);
        this.enginePath.addErrorListener(new ErrorListener(){

            @Override
            public void errorOccured(ErrorEvent e) {
                okay.setEnabled(false);
                apply.setEnabled(false);
            }
        });
        this.enginePath.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EngineConfigDialog.this.engineExecutable.setBasePath(EngineConfigDialog.this.enginePath.getPath());
            }
        });
        this.enginePath.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EngineConfigDialog.this.workingDirOpts.checkDisplay();
            }
        });
        this.enginePath.addChangeListener(enableOkay);
        this.engineExecutable.addErrorListener(new ErrorListener(){

            @Override
            public void errorOccured(ErrorEvent e) {
                okay.setEnabled(false);
                apply.setEnabled(false);
            }
        });
        this.engineExecutable.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EngineConfigDialog.this.workingDirOpts.checkDisplay();
            }
        });
        this.engineExecutable.addChangeListener(enableOkay);
        this.downloadPath.addChangeListener(enableOkay);
        this.rogue.addChangeListener(enableOkay);
        this.hipnotic.addChangeListener(enableOkay);
        ActionListener save = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineConfigDialog.this.listeners.notifyChangeListeners(this);
                apply.setEnabled(false);
            }
        };
        okay.addActionListener(save);
        apply.addActionListener(save);
        ActionListener close = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EngineConfigDialog.this.setVisible(false);
                EngineConfigDialog.this.dispose();
            }
        };
        okay.addActionListener(close);
        cancel.addActionListener(close);
        OkayCancelApplyPanel okayCancelPanel = new OkayCancelApplyPanel(okay, cancel, apply, true);
        this.add((Component)okayCancelPanel, "Last");
    }

    public UIThemeOption getUiTheme() {
        return (UIThemeOption)((Object)this.uiTheme.getSelectedItem());
    }

    public File getEnginePath() {
        return this.enginePath.getPath();
    }

    public File getEngineExecutable() {
        return this.engineExecutable.getPath();
    }

    public boolean getWorkingDirAtExecutable() {
        return this.workingDirOpts.getWorkingDirAtExecutable();
    }

    public String getCommandline() {
        return this.engineCommandline.getText();
    }

    public boolean getHipnoticInstalled() {
        return this.hipnotic.isSelected();
    }

    public boolean getRogueInstalled() {
        return this.rogue.isSelected();
    }

    public File getDownloadPath() {
        return this.downloadPath.getPath();
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    class WorkingDirOpts {
        private final JSeparator workingDirBoxSep = new JSeparator(0);
        private final GridBagConstraints sepConstraints = new GridBagConstraints();
        private final JLabel workingDirTitle;
        private final GridBagConstraints titleConstraints;
        private final Box workingDirChoices;
        private final GridBagConstraints choicesConstraints;
        private final JRadioButton workAtExe;
        private boolean visible;

        public WorkingDirOpts(int configPanelRow, boolean workAtExeDefault) {
            this.sepConstraints.gridx = 0;
            this.sepConstraints.gridy = configPanelRow;
            this.sepConstraints.gridwidth = 0;
            this.sepConstraints.fill = 2;
            this.sepConstraints.insets = new Insets(10, 0, 10, 0);
            this.sepConstraints.weightx = 1.0;
            String workingDirBlurb = "<html><body><nobr><b>Notice:</b> your Quake Executable is not located in your Quake Directory.<br/>Choose where the runtime \"working directory\" for Quake should be located:</nobr></body></html>";
            this.workingDirTitle = new JLabel(workingDirBlurb);
            this.titleConstraints = new GridBagConstraints();
            this.titleConstraints.gridx = 0;
            this.titleConstraints.gridy = configPanelRow + 1;
            this.titleConstraints.gridwidth = 0;
            this.workingDirChoices = new Box(1);
            JRadioButton workInBase = new JRadioButton("in Quake Directory");
            String baseBlurb = "Using the Quake Directory as the working directory may fail if necessary libraries or other resources are located with the engine.";
            workInBase.setToolTipText(baseBlurb);
            workInBase.setSelected(!workAtExeDefault);
            this.workAtExe = new JRadioButton("at Quake Executable");
            String exeBlurb = "Using the Quake Engine's location as the working directory may require adding a -basedir argument to the command line.";
            this.workAtExe.setToolTipText(exeBlurb);
            this.workAtExe.setSelected(workAtExeDefault);
            ButtonGroup workingDirGroup = new ButtonGroup();
            workingDirGroup.add(workInBase);
            workingDirGroup.add(this.workAtExe);
            this.workingDirChoices.add(workInBase);
            this.workingDirChoices.add(this.workAtExe);
            this.choicesConstraints = new GridBagConstraints();
            this.choicesConstraints.gridx = 0;
            this.choicesConstraints.gridy = configPanelRow + 2;
            this.choicesConstraints.gridwidth = 0;
            this.choicesConstraints.insets = new Insets(5, 0, 5, 0);
            this.visible = false;
            this.checkDisplay();
        }

        public void checkDisplay() {
            boolean showOpt;
            File exeDir = null;
            if (null != EngineConfigDialog.this.engineExecutable) {
                exeDir = EngineConfigDialog.this.engineExecutable.getPath().getParentFile();
            }
            boolean validPaths = null != exeDir && null != EngineConfigDialog.this.enginePath && !exeDir.getPath().equals("") && !EngineConfigDialog.this.enginePath.getPath().getPath().equals("") && !EngineConfigDialog.this.engineExecutable.getPath().equals(EngineConfigDialog.this.enginePath.getPath());
            boolean bl = showOpt = validPaths && !EngineConfigDialog.this.enginePath.getPath().equals(exeDir);
            if (showOpt) {
                if (!this.visible) {
                    EngineConfigDialog.this.configPanel.add((Component)this.workingDirBoxSep, this.sepConstraints);
                    EngineConfigDialog.this.configPanel.add((Component)this.workingDirTitle, this.titleConstraints);
                    EngineConfigDialog.this.configPanel.add((Component)this.workingDirChoices, this.choicesConstraints);
                    this.verticalRepack();
                    this.visible = true;
                }
            } else if (this.visible) {
                EngineConfigDialog.this.configPanel.remove(this.workingDirBoxSep);
                EngineConfigDialog.this.configPanel.remove(this.workingDirTitle);
                EngineConfigDialog.this.configPanel.remove(this.workingDirChoices);
                this.verticalRepack();
                this.visible = false;
            }
        }

        private void verticalRepack() {
            EngineConfigDialog dialog = EngineConfigDialog.this;
            Rectangle bounds = dialog.getBounds();
            dialog.setMinimumSize(new Dimension(bounds.width, 0));
            dialog.pack();
            dialog.setMinimumSize(null);
        }

        public boolean getWorkingDirAtExecutable() {
            return this.workAtExe.isSelected();
        }
    }
}

