/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public class EngineStarter {
    private File workingDir;
    private File quakeExe;
    private String quakeCmdline;

    private static boolean isMacOSX() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    private static boolean isMacApplication(File app) {
        return app.isDirectory() && app.getName().endsWith(".app");
    }

    private static boolean isExecutable(File exe) {
        return !exe.isDirectory() && exe.canExecute();
    }

    public static boolean isValidApplication(File app) {
        if (!app.exists() || !app.canRead()) {
            return false;
        }
        if (EngineStarter.isMacOSX() && EngineStarter.isMacApplication(app)) {
            return true;
        }
        return EngineStarter.isExecutable(app);
    }

    public static String errorMessageForApplication(File app) {
        if (!app.exists()) {
            return "Doesn't exist!";
        }
        if (EngineStarter.isMacOSX()) {
            if (!EngineStarter.isMacApplication(app) && !EngineStarter.isExecutable(app)) {
                return "Must be an application or executable!";
            }
            return null;
        }
        if (app.isDirectory()) {
            return "Must be an executable file!";
        }
        if (!app.canExecute()) {
            return "Cannot be executed!";
        }
        return null;
    }

    private static File executableForApplication(File app) {
        if (app != null && EngineStarter.isMacApplication(app)) {
            try {
                File contents = new File(app, "Contents");
                File plist = new File(contents, "Info.plist");
                File macOS = new File(contents, "MacOS");
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(plist);
                XPath xpath = XPathFactory.newInstance().newXPath();
                XPathExpression expr = xpath.compile("/plist/dict/key/text()[.='CFBundleExecutable']/../following-sibling::string[1]/text()");
                String cfBundleExecutable = expr.evaluate(document);
                File executable = new File(macOS, cfBundleExecutable);
                return executable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return app;
    }

    public EngineStarter(File workingDir, File quakeApp, Configuration.EngineCommandLine quakeCmdline) {
        this.workingDir = workingDir;
        this.setQuakeApplication(quakeApp);
        this.quakeCmdline = (String)quakeCmdline.get();
    }

    public Process start(String mapCmdline, String startmap) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>(5);
        cmd.add(this.quakeExe.getAbsolutePath());
        if (this.quakeCmdline != null) {
            for (String s : this.quakeCmdline.split(" ")) {
                cmd.add(s);
            }
        }
        if (mapCmdline != null) {
            for (String s : mapCmdline.split(" ")) {
                cmd.add(s);
            }
        }
        cmd.add("+map");
        cmd.add(startmap);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(this.workingDir);
        pb.redirectErrorStream(true);
        System.out.println(cmd);
        Process p = pb.start();
        return p;
    }

    public void setWorkingDirectory(File dir) {
        this.workingDir = dir;
    }

    public void setQuakeApplication(File quakeApp) {
        this.quakeExe = EngineStarter.executableForApplication(quakeApp);
    }

    public void setQuakeCommandline(Configuration.EngineCommandLine cmdline) {
        this.quakeCmdline = (String)cmdline.get();
    }

    public boolean checkPaths() {
        return this.quakeExe.exists() && !this.quakeExe.isDirectory() && this.quakeExe.canRead() && this.quakeExe.canExecute();
    }
}

