/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Cancelable;
import de.haukerehfeld.quakeinjector.CheckCanceledProgressListener;
import de.haukerehfeld.quakeinjector.CompressedProgressListener;
import de.haukerehfeld.quakeinjector.FileInfo;
import de.haukerehfeld.quakeinjector.FileNotWritableException;
import de.haukerehfeld.quakeinjector.Installer;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.PercentageProgressListener;
import de.haukerehfeld.quakeinjector.ProgressListener;
import de.haukerehfeld.quakeinjector.RelativePath;
import de.haukerehfeld.quakeinjector.SumProgressListener;
import de.haukerehfeld.quakeinjector.Utils;
import de.haukerehfeld.quakeinjector.repackage.ExtractMapping;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipException;
import javax.swing.SwingWorker;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class InstallWorker
extends SwingWorker<PackageFileList, Void>
implements ProgressListener,
Cancelable {
    private final File baseDirectory;
    private final ExtractMapping extractMapping;
    private final Package map;
    private final InputStream input;
    private final List<File> overwrites;
    private long downloadSize = 0L;
    private final PackageFileList files;

    public InstallWorker(InputStream input, long inputSize, Package map, File baseDirectory, ExtractMapping extractMapping, List<File> overwrites) {
        this.map = map;
        this.input = input;
        this.downloadSize = inputSize;
        this.baseDirectory = baseDirectory;
        this.extractMapping = extractMapping;
        this.files = new PackageFileList(map.getId());
        this.overwrites = overwrites;
    }

    @Override
    public PackageFileList doInBackground() throws IOException, FileNotFoundException, Installer.CancelledException, ArchiveException {
        System.out.println("Installing " + this.map.getId());
        this.unzip(this.input, this.baseDirectory, this.map.getId(), this.overwrites);
        this.map.setInstalled(true);
        return this.files;
    }

    public void unzip(InputStream in, File basedir, String mapid, List<File> overwrites) throws IOException, FileNotFoundException, Installer.CancelledException, ArchiveException {
        ArchiveEntry sourceEntry;
        SumProgressListener progress = new SumProgressListener(new PercentageProgressListener(this.downloadSize, new CheckCanceledProgressListener(this, this)));
        ArchiveInputStream archiveStream = new ArchiveStreamFactory().createArchiveInputStream(in);
        boolean extracted = false;
        while ((sourceEntry = archiveStream.getNextEntry()) != null) {
            ZipArchiveEntry zipEntry;
            long zipCrc;
            long crc;
            File targetWritable = this.getTargetFile(sourceEntry);
            if (targetWritable == null) continue;
            String filename = RelativePath.getRelativePath(basedir, targetWritable).toString();
            if (overwrites != null && overwrites.indexOf(targetWritable) < 0) {
                System.out.println("Skipping " + filename + ", because it isn't supposed to be overwritten.");
                continue;
            }
            List<File> createdDirs = Utils.mkdirs(targetWritable);
            if (sourceEntry.isDirectory()) continue;
            File overwrittenFile = targetWritable;
            if (targetWritable.exists()) {
                targetWritable = File.createTempFile("quakeinjector", ".tmp", targetWritable.getParentFile());
                System.out.println("create Temp file " + targetWritable);
            }
            System.out.println("Writing " + filename + " (" + sourceEntry.getSize() + " B)");
            try {
                crc = Utils.writeFile((InputStream)archiveStream, targetWritable, new CompressedProgressListener((double)sourceEntry.getSize() / (double)sourceEntry.getSize(), progress));
            }
            catch (FileNotFoundException e) {
                throw new FileNotWritableException(e.getMessage());
            }
            if (sourceEntry instanceof ZipArchiveEntry && (zipCrc = (zipEntry = (ZipArchiveEntry)sourceEntry).getCrc()) != -1L && zipCrc != crc) {
                System.err.println("Crc32 didn't match on extraction of " + overwrittenFile + ", removing...");
                targetWritable.delete();
                continue;
            }
            FileInfo info = new FileInfo(filename, crc);
            this.files.add(info);
            for (File dirname : createdDirs) {
                this.files.add(new FileInfo(RelativePath.getRelativePath(basedir, dirname).toString(), 0L));
            }
            if (!targetWritable.equals(overwrittenFile)) {
                overwrittenFile.delete();
                System.out.println("moving Temp file to " + overwrittenFile);
                targetWritable.renameTo(overwrittenFile);
            }
            extracted = true;
        }
        if (!extracted) {
            throw new ZipException("No files extracted from zip, is it an empty file?");
        }
        archiveStream.close();
    }

    private File getTargetFile(ArchiveEntry sourceEntry) {
        String extractPath = this.extractMapping.remap(sourceEntry.getName());
        if (extractPath != null) {
            return new File(this.baseDirectory, extractPath);
        }
        return null;
    }

    @Override
    public void publish(long progress) {
        if (progress <= 100L) {
            this.setProgress((int)progress);
        }
    }

    @Override
    public void checkCancelled() throws Installer.CancelledException {
        if (this.isCancelled()) {
            System.out.println("canceling...");
            throw new Installer.CancelledException();
        }
    }

    public PackageFileList getInstalledFiles() {
        return this.files;
    }
}

