/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Configuration;
import de.haukerehfeld.quakeinjector.Download;
import de.haukerehfeld.quakeinjector.DownloadWorker;
import de.haukerehfeld.quakeinjector.FileNotWritableException;
import de.haukerehfeld.quakeinjector.InspectZipWorker;
import de.haukerehfeld.quakeinjector.InstallWorker;
import de.haukerehfeld.quakeinjector.OnlineFileNotFoundException;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.RelativePath;
import de.haukerehfeld.quakeinjector.UninstallWorker;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.compress.archivers.ArchiveEntry;

public class Installer {
    private static final int simultanousDownloads = 1;
    private static final int simultanousInstalls = 1;
    private static final int simultanousInspectors = 1;
    private static final int simultanousWaiters = 15;
    private final Configuration.EnginePath installDirectory;
    private final Configuration.DownloadPath downloadDirectory;
    private final ExecutorService activeDownloaders = Executors.newFixedThreadPool(1);
    private final ExecutorService activeInspectors = Executors.newFixedThreadPool(1);
    private final ExecutorService activeInstallers = Executors.newFixedThreadPool(1);
    private final ExecutorService activeWaiters = Executors.newFixedThreadPool(15);
    private final Map<Package, Worker> queue = new HashMap<Package, Worker>();

    public Installer(Configuration.EnginePath installDirectory, Configuration.DownloadPath downloadDirectory) {
        this.installDirectory = installDirectory;
        this.downloadDirectory = downloadDirectory;
    }

    public boolean checkInstallDirectory() {
        if (!this.installDirectory.existsOrDefault()) {
            return false;
        }
        return ((File)this.installDirectory.get()).canWrite();
    }

    public boolean checkDownloadDirectory() {
        if (!this.downloadDirectory.existsOrDefault()) {
            return false;
        }
        return this.downloadDirectory.get().canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Map<Package, Worker> map = this.queue;
        synchronized (map) {
            for (Package inQueue : new HashSet<Package>(this.getQueue())) {
                this.cancel(inQueue);
                System.out.println("Canceling " + inQueue);
            }
        }
    }

    public boolean working() {
        return !this.queue.isEmpty();
    }

    public Set<Package> getQueue() {
        return this.queue.keySet();
    }

    public boolean alreadyQueued(Package map) {
        return this.queue.get(map) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(Package selectedMap, String url, InstallErrorHandler errorHandler, PropertyChangeListener downloadProgressListener) {
        if (this.alreadyQueued(selectedMap)) {
            return;
        }
        Worker saveInstalled = new Worker(url, selectedMap, errorHandler, downloadProgressListener);
        Object object = this.queue;
        synchronized (object) {
            this.queue.put(selectedMap, saveInstalled);
        }
        object = this.activeWaiters;
        synchronized (object) {
            this.activeWaiters.submit(saveInstalled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(Package installerMap) {
        Worker w;
        Map<Package, Worker> map = this.queue;
        synchronized (map) {
            w = this.queue.get(installerMap);
        }
        if (w != null) {
            w.cancel();
        }
    }

    public void uninstall(PackageFileList map, final UninstallErrorHandler errorHandler, PropertyChangeListener progressListener) {
        final UninstallWorker uninstall = new UninstallWorker(map, ((File)this.installDirectory.get()).getAbsolutePath());
        uninstall.addPropertyChangeListener(progressListener);
        uninstall.execute();
        new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    uninstall.get();
                    errorHandler.success();
                }
                catch (ExecutionException e) {
                    Throwable er = e.getCause();
                    if (er instanceof Exception) {
                        errorHandler.error((Exception)er);
                    } else {
                        errorHandler.error(e);
                    }
                }
                catch (InterruptedException e) {
                    System.out.println("Installer: " + e.getMessage());
                    e.printStackTrace();
                }
                return null;
            }
        }.execute();
    }

    private class Worker
    extends SwingWorker<Void, Void> {
        public InstallWorker installer;
        public DownloadWorker downloader;
        private Throwable error;
        private final String url;
        private final Package installedPackage;
        private final InstallErrorHandler handler;
        private final PropertyChangeListener downloadProgressListener;

        public Worker(String url, Package installedPackage, InstallErrorHandler handler, PropertyChangeListener downloadProgressListener) {
            this.url = url;
            this.installedPackage = installedPackage;
            this.handler = handler;
            this.downloadProgressListener = downloadProgressListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void doInBackground() {
            block28: {
                try {
                    Map<String, File> existingFiles;
                    long downloadSize;
                    File downloadFile = new File(Installer.this.downloadDirectory.get().getAbsolutePath() + File.separator + this.installedPackage.getId() + ".zip");
                    System.out.println("Downloading to " + downloadFile);
                    if (!downloadFile.exists()) {
                        downloadFile.getParentFile().mkdirs();
                        FileOutputStream out = new FileOutputStream(downloadFile);
                        try {
                            downloadSize = this.download(this.url, out);
                            out.flush();
                            out.close();
                        }
                        catch (Exception e) {
                            out.close();
                            System.out.print("Error downloading file, removing...");
                            if (!downloadFile.delete()) {
                                System.err.print("Couldn't delete partially downloaded file (" + downloadFile + ")! ");
                            }
                            System.out.println("done.");
                            throw e;
                        }
                    } else {
                        downloadSize = downloadFile.length();
                        System.out.println("Skipping download, already existing with length " + downloadSize);
                    }
                    System.out.println("Inspecting downloaded archive..." + downloadFile);
                    try (BufferedInputStream inspectStream = new BufferedInputStream(new FileInputStream(downloadFile));){
                        existingFiles = this.findExistingFiles(inspectStream);
                    }
                    System.out.println("done.");
                    List<File> overwrites = null;
                    if (existingFiles != null) {
                        overwrites = this.askForOverwrite(existingFiles);
                    }
                    System.out.println("After asking");
                    if (overwrites == null || !overwrites.isEmpty()) {
                        System.out.println("Starting install");
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(downloadFile));
                        this.installer = new InstallWorker(in, downloadSize, this.installedPackage, (File)Installer.this.installDirectory.get(), this.installedPackage.getExtractMapping(), overwrites);
                        ExecutorService executorService = Installer.this.activeInstallers;
                        synchronized (executorService) {
                            Installer.this.activeInstallers.submit(this.installer);
                        }
                        try {
                            this.installer.get();
                            break block28;
                        }
                        catch (Exception e) {
                            throw e;
                        }
                        finally {
                            in.close();
                        }
                    }
                    System.out.println("Canceling install");
                    this.cancel();
                }
                catch (FileNotFoundException e) {
                    this.error = e;
                }
                catch (IOException e) {
                    this.error = e;
                }
                catch (CancellationException e) {
                    this.error = e;
                }
                catch (InterruptedException e) {
                    this.error = e;
                }
                catch (ExecutionException e) {
                    this.error = e.getCause();
                }
                catch (Exception e) {
                    this.error = e;
                    System.err.println("Caught 'unchecked' exception in Installer.Worker.doBackground(): " + e);
                    e.printStackTrace();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long download(String url, FileOutputStream out) throws IOException, InterruptedException, ExecutionException {
            Download download = Download.create(url);
            this.downloader = new DownloadWorker(download, out);
            this.downloader.addPropertyChangeListener(this.downloadProgressListener);
            ExecutorService executorService = Installer.this.activeDownloaders;
            synchronized (executorService) {
                Installer.this.activeDownloaders.submit(this.downloader);
            }
            return (Long)this.downloader.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, File> findExistingFiles(InputStream in) throws IOException, InterruptedException, ExecutionException {
            InspectZipWorker inspector = new InspectZipWorker(in);
            ExecutorService executorService = Installer.this.activeInspectors;
            synchronized (executorService) {
                Installer.this.activeInspectors.submit(inspector);
            }
            System.out.println("Waiting for inspection...");
            List entries = (List)inspector.get();
            HashMap<String, File> files = new HashMap<String, File>();
            boolean existingFile = false;
            for (ArchiveEntry z : entries) {
                File f;
                if (z.isDirectory() || (f = Installer.this.installDirectory.getUnzipFile(this.installedPackage, z.getName())) == null) continue;
                String name = RelativePath.getRelativePath((File)Installer.this.installDirectory.get(), f).toString();
                files.put(name, f);
                if (!f.exists()) continue;
                existingFile = true;
            }
            if (!existingFile) {
                return null;
            }
            return files;
        }

        private List<File> askForOverwrite(final Map<String, File> files) throws InterruptedException, InvocationTargetException, ExecutionException {
            SwingWorker<List<File>, Void> dialogue = new SwingWorker<List<File>, Void>(){

                @Override
                public List<File> doInBackground() {
                    return Worker.this.handler.overwrite(files);
                }
            };
            SwingUtilities.invokeAndWait(dialogue);
            List overwrites = (List)dialogue.get();
            return overwrites;
        }

        public void cancel() {
            if (this.downloader != null) {
                this.downloader.cancel(true);
            }
            if (this.installer != null) {
                this.installer.cancel(true);
            }
            this.cancel(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            PackageFileList files = this.installer != null ? this.installer.getInstalledFiles() : new PackageFileList(this.installedPackage.getId());
            if (this.error != null) {
                try {
                    throw this.error;
                }
                catch (OnlineFileNotFoundException error) {
                    this.handler.handle(error);
                }
                catch (SocketException error) {
                    this.handler.handle(error, files);
                }
                catch (FileNotWritableException error) {
                    this.handler.handle(error, files);
                }
                catch (IOException error) {
                    this.handler.handle(error, files);
                }
                catch (Throwable e) {
                    System.out.println("unhandled exception from install worker" + this.error);
                    this.error.printStackTrace();
                }
                this.installer = null;
                this.downloader = null;
            } else if (this.isCancelled()) {
                System.out.println("CancelledException!");
                this.handler.handle(new CancelledException(), files);
            } else {
                System.out.println("Success installing");
                this.handler.success(files);
            }
            System.out.println("Done saving installedmaps");
            Map<Package, Worker> map = Installer.this.queue;
            synchronized (map) {
                Installer.this.queue.remove(this.installedPackage);
            }
        }
    }

    public static interface InstallErrorHandler {
        public List<File> overwrite(Map<String, File> var1);

        public void success(PackageFileList var1);

        public void handle(OnlineFileNotFoundException var1);

        public void handle(FileNotWritableException var1, PackageFileList var2);

        public void handle(IOException var1, PackageFileList var2);

        public void handle(SocketException var1, PackageFileList var2);

        public void handle(CancelledException var1, PackageFileList var2);
    }

    public static interface UninstallErrorHandler {
        public void success();

        public void error(Exception var1);
    }

    public static class CancelledException
    extends RuntimeException {
    }
}

