/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.ChangeListenerList;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.SortableRequirement;
import de.haukerehfeld.quakeinjector.repackage.ExtractMapping;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.ChangeListener;

public class Package
extends SortableRequirement
implements Requirement {
    private ChangeListenerList listeners = new ChangeListenerList();
    private String sha256;
    private String filename;
    private List<String> downloadUrls;
    private String author;
    private String title;
    private float normalizedUsersRating;
    private String description;
    private int size;
    private Date date;
    private final ExtractMapping extractMapping;
    private String commandline;
    private List<String> startmaps;
    private List<Requirement> requirements;
    private PackageFileList fileList;
    private PackageFileList supposedFileList;

    public Package(String id, String sha256, String filename, List<String> downloadUrls, String author, String title, int size, Date date, boolean isInstalled, float normalizedUsersRating, String description, ExtractMapping extractMapping, String commandline, List<String> startmaps, List<Requirement> requirements) {
        super(id);
        this.sha256 = sha256;
        this.filename = filename;
        this.downloadUrls = downloadUrls;
        this.author = author;
        this.title = title;
        this.size = size;
        this.date = date;
        super.setInstalled(isInstalled);
        this.normalizedUsersRating = normalizedUsersRating;
        this.description = description;
        this.extractMapping = extractMapping;
        this.commandline = commandline;
        this.startmaps = startmaps;
        this.requirements = requirements;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    public String getSha256() {
        return this.sha256;
    }

    public String getFilename() {
        return this.filename;
    }

    public List<String> getDownloadUrls() {
        return this.downloadUrls;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public Date getDate() {
        return this.date;
    }

    public float getNormalizedUsersRating() {
        return this.normalizedUsersRating;
    }

    public String getDescription() {
        return this.description;
    }

    public ExtractMapping getExtractMapping() {
        return this.extractMapping;
    }

    public String getCommandline() {
        return this.commandline;
    }

    public List<String> getStartmaps() {
        return this.startmaps;
    }

    public void setRequirements(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public List<Package> getAvailableRequirements() {
        ArrayList<Package> avails = new ArrayList<Package>();
        for (Requirement r : this.requirements) {
            if (!(r instanceof Package)) continue;
            avails.add((Package)r);
        }
        return avails;
    }

    public List<Requirement> getUnavailableRequirements() {
        ArrayList<Requirement> unavails = new ArrayList<Requirement>();
        for (Requirement r : this.requirements) {
            if (r.isInstalled() || r instanceof Package) continue;
            unavails.add(r);
        }
        return unavails;
    }

    public List<Requirement> getUnmetRequirements() {
        ArrayList<Requirement> unmet = new ArrayList<Requirement>();
        for (Requirement requirement : this.requirements) {
            if (requirement.isInstalled()) continue;
            unmet.add(requirement);
        }
        return unmet;
    }

    @Override
    protected void notifyChangeListeners() {
        this.listeners.notifyChangeListeners(this);
    }

    @Override
    public String toString() {
        return this.getId() + " (" + this.isInstalled() + ")";
    }

    @Override
    public PackageFileList getFileList() {
        return this.fileList;
    }

    public void setFileList(PackageFileList fileList) {
        this.fileList = fileList;
    }

    public PackageFileList getSupposedFileList() {
        return this.supposedFileList;
    }

    public void setSupposedFileList(PackageFileList supposedFileList) {
        this.supposedFileList = supposedFileList;
    }
}

