/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Configuration;
import de.haukerehfeld.quakeinjector.Download;
import de.haukerehfeld.quakeinjector.PackageDatabaseSolrJsonParser;
import de.haukerehfeld.quakeinjector.PercentageProgressListener;
import de.haukerehfeld.quakeinjector.ProgressListener;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.SumProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.swing.SwingWorker;
import org.xml.sax.SAXException;

public class PackageDatabaseParserWorker
extends SwingWorker<List<Requirement>, Void>
implements ProgressListener {
    private final Configuration configuration;

    public PackageDatabaseParserWorker(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<Requirement> doInBackground() throws IOException, SAXException {
        InputStream dl = this.getDownloadStream((String)this.configuration.RepositoryDatabasePath.get());
        PackageDatabaseSolrJsonParser parser = new PackageDatabaseSolrJsonParser(this.configuration);
        List<Requirement> all = parser.parse(dl);
        return all;
    }

    @Override
    public void done() {
    }

    private InputStream getDownloadStream(String databaseUrl) throws IOException {
        InputStream dl;
        Download d = Download.create(databaseUrl);
        d.connect();
        int size = d.getSize();
        if (size > 0) {
            SumProgressListener progress = new SumProgressListener(new PercentageProgressListener(size, this));
            dl = d.getStream(progress);
        } else {
            dl = d.getStream(null);
        }
        return dl;
    }

    @Override
    public void publish(long progress) {
        if (progress <= 100L) {
            this.setProgress((int)progress);
        }
    }
}

