/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import de.haukerehfeld.quakeinjector.Configuration;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageDatabaseParseException;
import de.haukerehfeld.quakeinjector.PackageDatabaseParser;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.UnavailableRequirement;
import de.haukerehfeld.quakeinjector.repackage.ExtractMapping;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackageDatabaseSolrJsonParser
implements PackageDatabaseParser {
    private final SimpleDateFormat dateParser = new SimpleDateFormat("yyyy-MM-dd");
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Configuration configuration;

    public PackageDatabaseSolrJsonParser(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<Requirement> parse(InputStream is) {
        List<JsonPackage> jsonPackages = this.parseJsonPackages(is);
        ArrayList<Requirement> result = new ArrayList<Requirement>(jsonPackages.size());
        HashMap<String, Requirement> packages = new HashMap<String, Requirement>();
        HashMap<Package, List<String>> unresolvedRequirements = new HashMap<Package, List<String>>();
        for (JsonPackage jsonPackage : jsonPackages) {
            Package pkg;
            try {
                pkg = this.getPackage(jsonPackage, unresolvedRequirements);
            }
            catch (PackageDatabaseParseException e) {
                System.err.printf("Cannot process package %s:%n%s%n%n", jsonPackage.sha256, e.getMessage());
                continue;
            }
            catch (Exception e) {
                System.err.printf("Cannot process package %s:%n%s%n%n", jsonPackage.sha256, e.getMessage());
                e.printStackTrace();
                continue;
            }
            result.add(pkg);
            packages.put(pkg.getId(), pkg);
        }
        this.resolveRequirements(unresolvedRequirements, packages);
        return result;
    }

    private Package getPackage(JsonPackage jsonPackage, Map<Package, List<String>> unresolvedRequirements) {
        ProcessedTags processedTags = this.processTags(jsonPackage.tags);
        Date releaseDate = null;
        try {
            releaseDate = this.dateParser.parse(processedTags.release_date);
        }
        catch (ParseException e) {
            throw new PackageDatabaseParseException("Cannot parse date '" + processedTags.release_date + "': " + e.getMessage());
        }
        ExtractMapping extractMapping = this.getExtractMapping(jsonPackage, processedTags);
        StringBuilder description = this.getDescription(jsonPackage, processedTags);
        List<String> urls = this.getDownloadUrls(jsonPackage, processedTags);
        String legacyId = this.stripExtension(processedTags.filename);
        List<String> startMaps = this.reorderStartMaps(processedTags.startMaps);
        if (startMaps.isEmpty()) {
            startMaps.add(legacyId);
        }
        Package pkg = new Package(legacyId, jsonPackage.sha256, processedTags.filename, urls, String.join((CharSequence)", ", processedTags.authors), processedTags.title, (int)(jsonPackage.bytes / 1000L), releaseDate, false, (float)Math.random() * 5.0f, description.toString(), extractMapping, processedTags.commandLine, startMaps, Collections.emptyList());
        unresolvedRequirements.put(pkg, processedTags.dependencies);
        return pkg;
    }

    private List<String> reorderStartMaps(List<String> startMaps) {
        ArrayList<String> preferredStartMaps = new ArrayList<String>(startMaps.size());
        ArrayList<String> otherStartMaps = new ArrayList<String>(startMaps.size());
        for (String map : startMaps) {
            if (map.contains("start")) {
                preferredStartMaps.add(map);
                continue;
            }
            otherStartMaps.add(map);
        }
        ArrayList<String> result = new ArrayList<String>(preferredStartMaps.size() + otherStartMaps.size());
        result.addAll(preferredStartMaps);
        result.addAll(otherStartMaps);
        return result;
    }

    private ExtractMapping getExtractMapping(JsonPackage jsonPackage, ProcessedTags processedTags) {
        Install install;
        ExtractMapping mapping = new ExtractMapping();
        if (processedTags.zipbasedir != null) {
            mapping.addMapping("/", processedTags.zipbasedir);
        }
        if ((install = jsonPackage.install) != null) {
            if (install.extract != null) {
                mapping.addMapping("/", install.extract);
            }
            if (install.extractmapping != null) {
                for (Map.Entry<String, String> entry : install.extractmapping.entrySet()) {
                    mapping.addMapping(entry.getKey(), entry.getValue());
                }
            }
        }
        return mapping;
    }

    private List<String> getDownloadUrls(JsonPackage jsonPackage, ProcessedTags processedTags) {
        List<String> urls = jsonPackage.urls;
        if (urls == null || urls.isEmpty()) {
            urls = Collections.singletonList(this.configuration.RepositoryBasePath.getRepositoryUrl(processedTags.filename, jsonPackage.sha256));
        }
        return urls;
    }

    private StringBuilder getDescription(JsonPackage jsonPackage, ProcessedTags processedTags) {
        StringBuilder description = new StringBuilder(jsonPackage.description);
        if (jsonPackage.notes != null && !jsonPackage.notes.isEmpty()) {
            description.append("<br /><br />Notes:<br />");
            description.append(String.join((CharSequence)"<br /><br />", jsonPackage.notes));
        }
        description.append("<br /><br />Links:<ul>");
        description.append("<li><a href=\"").append((String)this.configuration.mapWebpageBaseUrl.get()).append(jsonPackage.sha256).append("\">Quaddicted</a></li>");
        if (processedTags.links != null && !processedTags.links.isEmpty()) {
            for (String link : processedTags.links) {
                int separatorIndex = link.indexOf("](");
                if (!link.startsWith("[") || separatorIndex <= 0 || !link.endsWith(")")) continue;
                String desc = link.substring(1, separatorIndex);
                String href = link.substring(separatorIndex + 2, link.length() - 1);
                description.append("<li><a href=\"").append(href).append("\">").append(desc).append("</a></li>");
            }
        }
        description.append("</ul>");
        return description;
    }

    private List<JsonPackage> parseJsonPackages(InputStream is) {
        List jsonPackages;
        CollectionType type = this.objectMapper.getTypeFactory().constructCollectionType(List.class, JsonPackage.class);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            jsonPackages = (List)this.objectMapper.readValue(is, (JavaType)type);
        }
        catch (IOException e) {
            throw new PackageDatabaseParseException(e);
        }
        return jsonPackages;
    }

    private String stripExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return filename;
        }
        return filename.substring(0, index);
    }

    private ProcessedTags processTags(List<String> tags) {
        ProcessedTags processed = new ProcessedTags();
        for (String tag : tags) {
            if (tag.startsWith("filename=")) {
                processed.filename = tag.substring("filename=".length());
            }
            if (tag.startsWith("dependency=")) {
                processed.dependencies.add(tag.substring("dependency=".length()));
            }
            if (tag.startsWith("commandline=")) {
                processed.commandLine = tag.substring("commandline=".length());
            }
            if (tag.startsWith("startmap=")) {
                processed.startMaps.add(tag.substring("startmap=".length()));
            }
            if (tag.startsWith("zipbasedir=")) {
                processed.zipbasedir = tag.substring("zipbasedir=".length());
            }
            if (tag.startsWith("link=")) {
                processed.links.add(tag.substring("link=".length()));
            }
            if (tag.startsWith("title=")) {
                processed.title = tag.substring("title=".length());
            }
            if (tag.startsWith("author=")) {
                processed.authors.add(tag.substring("author=".length()));
            }
            if (!tag.startsWith("release_date")) continue;
            processed.release_date = tag.substring("release_date=".length());
        }
        return processed;
    }

    private void resolveRequirements(Map<Package, List<String>> unresolvedRequirements, Map<String, Requirement> packages) {
        for (Map.Entry<Package, List<String>> entry : unresolvedRequirements.entrySet()) {
            Package current = entry.getKey();
            List<String> reqs = entry.getValue();
            ArrayList<Requirement> resolvedRequirements = new ArrayList<Requirement>(reqs.size());
            for (String id : reqs) {
                Requirement resolved = packages.get(id);
                if (resolved == null) {
                    resolved = new UnavailableRequirement(id);
                    packages.put(id, resolved);
                }
                resolvedRequirements.add(resolved);
            }
            current.setRequirements(resolvedRequirements);
        }
    }

    private static class JsonPackage {
        public String sha256;
        public List<String> tags;
        public List<String> urls;
        public long bytes;
        public List<String> notes;
        public Install install;
        public String description;

        private JsonPackage() {
        }
    }

    private static class ProcessedTags {
        public String release_date;
        public String title;
        public String filename;
        public List<String> dependencies = new ArrayList<String>();
        public String commandLine;
        public List<String> startMaps = new ArrayList<String>();
        public String zipbasedir;
        public List<String> links = new ArrayList<String>();
        public List<String> authors = new ArrayList<String>();

        private ProcessedTags() {
        }
    }

    private static class Install {
        public String extract;
        public Map<String, String> extractmapping;

        private Install() {
        }
    }
}

