/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.packagelist.model.PackageListModel;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class PackageListSelectionHandler
implements ListSelectionListener {
    private PackageListModel list;
    private JTable table;
    private ArrayList<SelectionListener> listeners = new ArrayList();
    private int lastSelection = -1;

    public PackageListSelectionHandler(PackageListModel list, JTable table) {
        this.list = list;
        this.table = table;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!lsm.isSelectionEmpty()) {
            int selection = this.table.convertRowIndexToModel(this.getSelection(lsm));
            if (this.lastSelection == selection) {
                return;
            }
            this.notifySelectionListeners(this.list.getPackage(selection));
            this.lastSelection = selection;
        }
    }

    public int getSelection(ListSelectionModel lsm) {
        int selection = -1;
        int minIndex = lsm.getMinSelectionIndex();
        int maxIndex = lsm.getMaxSelectionIndex();
        for (int i = minIndex; i <= maxIndex; ++i) {
            if (!lsm.isSelectedIndex(i)) continue;
            selection = i;
            break;
        }
        return selection;
    }

    public void addSelectionListener(SelectionListener l) {
        this.listeners.add(l);
    }

    private void notifySelectionListeners(Package selection) {
        for (SelectionListener l : this.listeners) {
            l.selectionChanged(selection);
        }
    }

    public static interface SelectionListener {
        public void selectionChanged(Package var1);
    }
}

