/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.gui.OkayCancelApplyPanel;
import de.haukerehfeld.quakeinjector.gui.ScrollablePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class PackageOverwriteDialog
extends JDialog {
    private static final String windowTitle = "Overwrite Package Files?";
    private static final int BUTTONMARGIN = 6;
    private static final int MARGINWIDTH = 5;
    private static final int DESCRIPTIONMARGINWIDTH = 10;
    private static final int DESCRIPTIONMARGINHEIGHT = 10;
    private static final Border DESCRIPTIONMARGIN = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private static final int LINEENTRYMARGINWIDTH = 9;
    private static final int LINEENTRYMARGINHEIGHT = 2;
    private static final Border LINEENTRYMARGIN = BorderFactory.createEmptyBorder(2, 9, 2, 9);
    private static final int CHECKBOXINDENT = 17;
    private static final int CHECKBOXEXTRAMARGIN = 0;
    private static final Border NOCHECKBOXLINEENTRYMARGIN = BorderFactory.createEmptyBorder(2, 26, 2, 9);
    private static final int SECTIONMARGIN = 15;
    private final JFrame parent;
    private final JPanel panel;
    private boolean canceled = true;
    private ArrayList<String> overwriteList = new ArrayList();
    private ArrayList<String> alwaysWriteList = new ArrayList();
    private final Map<String, JCheckBox> overwriteBoxes = new HashMap<String, JCheckBox>();

    public PackageOverwriteDialog(JFrame frame) {
        super(frame, windowTitle, true);
        this.parent = frame;
        this.panel = new ScrollablePanel(50, 50);
        this.panel.setLayout(new GridBagLayout());
        this.panel.setOpaque(false);
        JScrollPane panelScroll = new JScrollPane(this.panel);
        panelScroll.getViewport().setBackground(UIManager.getColor("TextPane.background"));
        this.add((Component)panelScroll, "Center");
        JButton okay = new JButton("Write files");
        JButton cancel = new JButton("Cancel");
        okay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageOverwriteDialog.this.canceled = false;
                PackageOverwriteDialog.this.setVisible(false);
                PackageOverwriteDialog.this.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PackageOverwriteDialog.this.setVisible(false);
                PackageOverwriteDialog.this.dispose();
            }
        });
        this.add((Component)new OkayCancelApplyPanel(okay, cancel, null, false), "Last");
    }

    private void addDescriptionLabel(String text, final int line) {
        JLabel description = new JLabel(text);
        description.setLabelFor(this);
        description.setOpaque(true);
        description.setBorder(DESCRIPTIONMARGIN);
        this.panel.add((Component)description, new GridBagConstraints(){
            {
                this.gridy = line;
                this.gridwidth = 2;
                this.fill = 1;
                this.anchor = 21;
            }
        });
    }

    private void addDescription() {
        this.addDescriptionLabel(windowTitle, 0);
    }

    private void addAlwaysWriteDescription(int line) {
        this.addDescriptionLabel("Files that need to be installed:", line);
    }

    public void addFile(String name, boolean overwrite) {
        ArrayList<String> list = overwrite ? this.overwriteList : this.alwaysWriteList;
        list.add(name);
    }

    public List<String> getOverwritten() {
        ArrayList<String> overwritten = new ArrayList<String>(this.alwaysWriteList);
        for (Map.Entry<String, JCheckBox> e : this.overwriteBoxes.entrySet()) {
            String name = e.getKey();
            JCheckBox box = e.getValue();
            if (!box.isSelected()) continue;
            overwritten.add(name);
        }
        return overwritten;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void packAndShow() {
        int finalLines;
        this.addDescription();
        int lines = 1;
        Collections.sort(this.overwriteList);
        for (String name : this.overwriteList) {
            JCheckBox overwrite = new JCheckBox(name);
            overwrite.setSelected(true);
            overwrite.setOpaque(false);
            overwrite.setBorder(LINEENTRYMARGIN);
            finalLines = lines++;
            this.panel.add((Component)overwrite, new OverwriteBoxConstraints(){
                {
                    this.gridy = finalLines;
                }
            });
            this.overwriteBoxes.put(name, overwrite);
        }
        if (!this.alwaysWriteList.isEmpty()) {
            final int finalLines2 = lines++;
            this.panel.add(Box.createRigidArea(new Dimension(0, 15)), new GridBagConstraints(){
                {
                    this.gridy = finalLines2;
                }
            });
            Collections.sort(this.alwaysWriteList);
            this.addAlwaysWriteDescription(lines++);
            for (String name : this.alwaysWriteList) {
                JLabel listEntry = new JLabel(name);
                listEntry.setOpaque(false);
                listEntry.setBorder(NOCHECKBOXLINEENTRYMARGIN);
                finalLines = lines++;
                this.panel.add((Component)listEntry, new OverwriteBoxConstraints(){
                    {
                        this.gridy = finalLines;
                    }
                });
            }
        }
        this.pack();
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
    }

    class OverwriteBoxConstraints
    extends GridBagConstraints {
        OverwriteBoxConstraints() {
            this.anchor = 21;
            this.fill = 2;
            this.weightx = 1.0;
        }
    }
}

