/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.packagelist.model.Column;
import de.haukerehfeld.quakeinjector.packagelist.model.PackageListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class PackageTable
extends JTable {
    private static final int ALTERNATING = 10;
    private static final Color NORMALROWCOLOR = UIManager.getColor("Table.background");
    private static final Color ALTERNATINGROWCOLOR = PackageTable.createAlternatingColor(NORMALROWCOLOR, 10);
    private static final int CELLPADDING = 2;
    private final EmptyBorder border = new EmptyBorder(0, 2, 0, 2);

    public PackageTable(PackageListModel maplist) {
        super(maplist);
        TableRowSorter<PackageListModel> sorter = new TableRowSorter<PackageListModel>(maplist);
        this.setRowSorter(sorter);
        sorter.toggleSortOrder(Column.RELEASEDATE.ordinal());
        sorter.toggleSortOrder(Column.RELEASEDATE.ordinal());
        this.setPreferredScrollableViewportSize(new Dimension(500, 500));
        this.setFillsViewportHeight(true);
        this.setColumnSelectionAllowed(false);
        this.setSelectionMode(0);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (!PackageTable.isRatingColumn(c)) {
            this.prepareNonRatingColumnRenderer(row, column, c);
        } else {
            this.prepareRatingColumnRenderer(row, column, c);
        }
        return c;
    }

    private void prepareNonRatingColumnRenderer(int row, int column, Component c) {
        if (!this.isCellSelected(row, column)) {
            c.setBackground(this.colorForRow(row));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else {
            c.setBackground(UIManager.getColor("Table.selectionBackground"));
            c.setForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(this.border);
        }
    }

    private void prepareRatingColumnRenderer(int row, int column, Component c) {
        if (this.isCellSelected(row, column)) {
            c.setForeground(UIManager.getColor("Table.foreground"));
        }
        if (c instanceof JComponent) {
            ((JComponent)c).setBorder(new EmptyBorder(0, 0, 0, 0));
        }
    }

    private static boolean isRatingColumn(Component c) {
        return c instanceof PackageListModel.BarRenderer;
    }

    protected Color colorForRow(int row) {
        return row % 2 == 0 ? NORMALROWCOLOR : ALTERNATINGROWCOLOR;
    }

    public TableRowSorter<PackageListModel> getRowSorter() {
        return (TableRowSorter)super.getRowSorter();
    }

    public static Color createAlternatingColor(Color c, int amount) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color(r > 127 ? r - amount : r + amount, g > 127 ? g - amount : g + amount, b > 127 ? b - amount : b + amount);
    }
}

