/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.ProgressListener;
import java.io.IOException;
import java.io.InputStream;

public class ProgressListenerInputStream
extends InputStream {
    private final InputStream in;
    private final ProgressListener progress;

    public ProgressListenerInputStream(InputStream in, ProgressListener progress) {
        this.in = in;
        this.progress = progress;
    }

    @Override
    public int read() throws IOException {
        this.progress.publish(1L);
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readcount = this.in.read(b, off, len);
        if (readcount > 0) {
            this.progress.publish(readcount);
        }
        return readcount;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

