/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.BuildCommit;
import de.haukerehfeld.quakeinjector.CheckInstalled;
import de.haukerehfeld.quakeinjector.Configuration;
import de.haukerehfeld.quakeinjector.Download;
import de.haukerehfeld.quakeinjector.DumpInputStream;
import de.haukerehfeld.quakeinjector.EngineConfigDialog;
import de.haukerehfeld.quakeinjector.EngineStarter;
import de.haukerehfeld.quakeinjector.InstallQueuePanel;
import de.haukerehfeld.quakeinjector.InstalledPackages;
import de.haukerehfeld.quakeinjector.Installer;
import de.haukerehfeld.quakeinjector.Menu;
import de.haukerehfeld.quakeinjector.Package;
import de.haukerehfeld.quakeinjector.PackageDatabaseSolrJsonParser;
import de.haukerehfeld.quakeinjector.PackageDetailPanel;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.PackageInteractionPanel;
import de.haukerehfeld.quakeinjector.PackageList;
import de.haukerehfeld.quakeinjector.PackageListSelectionHandler;
import de.haukerehfeld.quakeinjector.PackageTable;
import de.haukerehfeld.quakeinjector.RelativePath;
import de.haukerehfeld.quakeinjector.Requirement;
import de.haukerehfeld.quakeinjector.RequirementList;
import de.haukerehfeld.quakeinjector.RuntimeExecutionException;
import de.haukerehfeld.quakeinjector.SaveInstalled;
import de.haukerehfeld.quakeinjector.Utils;
import de.haukerehfeld.quakeinjector.gui.ProgressPopup;
import de.haukerehfeld.quakeinjector.gui.UIThemeOption;
import de.haukerehfeld.quakeinjector.packagelist.model.PackageListModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultRowSorter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.xml.sax.SAXException;

public class QuakeInjector
extends JFrame {
    private static final String ICON_URL = "/Inject2_SIZE.png";
    private static final String ICON_SIZE_PLACEHOLDER = "SIZE";
    private static final int[] ICON_SIZES = new int[]{16, 32, 48, 256};
    private static final String applicationName = "Quake Injector";
    private static final int minWidth = 1024;
    private static final int minHeight = 768;
    private static final String installedMapsFileName = "installedMaps.xml";
    private static final File installedMapsFile = new File("installedMaps.xml");
    private final SaveInstalled saveInstalled = new SaveInstalled(installedMapsFile);
    private static final String zipFilesXml = "zipFiles.xml";
    static final File configFile = new File("config.properties");
    private EngineStarter starter;
    private PackageInteractionPanel interactionPanel;
    private RequirementList maps;
    private PackageList packages;
    private final PackageListModel maplist;
    private Installer installer;
    private final InstalledPackages installedMaps = new InstalledPackages();
    private Configuration.OfflineMode offline;
    private final Configuration config;
    private final Menu menu;

    public QuakeInjector() {
        super(applicationName);
        SwingWorker<Configuration, Void> config = new SwingWorker<Configuration, Void>(){

            @Override
            public Configuration doInBackground() {
                return new Configuration(configFile);
            }
        };
        ((SwingWorker)config).execute();
        Configuration cfg = null;
        try {
            cfg = (Configuration)config.get();
        }
        catch (ExecutionException e) {
            System.err.println("Couldn't load config: " + e.getCause());
            e.getCause().printStackTrace();
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted: " + e);
        }
        this.config = cfg;
        this.loadTheme();
        this.setDefaultCloseOperation(3);
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        this.maps = new RequirementList();
        this.packages = new PackageList(this.maps);
        this.maplist = new PackageListModel(this.packages);
        this.setIconImages(QuakeInjector.createIconList(ICON_SIZES, ICON_URL, ICON_SIZE_PLACEHOLDER));
        this.menu = this.createMenuBar();
        this.setJMenuBar(this.menu);
        this.setMinimumSize(new Dimension(1024, 768));
        this.offline = cfg.OfflineMode;
        this.addMainPane(this.getContentPane());
        this.addWindowListener(new QuakeInjectorWindowListener());
        this.setWindowSize();
    }

    private void loadTheme() {
        UIThemeOption option = (UIThemeOption)((Object)this.getConfig().uiTheme.get());
        if (option != null) {
            option.init();
        } else {
            UIThemeOption.SYSTEM.init();
        }
    }

    private Menu createMenuBar() {
        ActionListener parseDatabase = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuakeInjector.this.doParseInstalled();
                QuakeInjector.this.parseDatabaseAndSetList();
            }
        };
        ActionListener checkInstalled = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuakeInjector.this.checkForInstalledMaps();
            }
        };
        ActionListener quit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuakeInjector.this.setVisible(false);
                QuakeInjector.this.dispose();
            }
        };
        ActionListener showEngineConfig = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuakeInjector.this.showEngineConfig(QuakeInjector.this.maps.get("rogue").isInstalled(), QuakeInjector.this.maps.get("hipnotic").isInstalled());
            }
        };
        ActionListener offlineModeChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QuakeInjector.this.offline.set((Boolean)QuakeInjector.this.offline.get() == false);
            }
        };
        return new Menu(parseDatabase, checkInstalled, quit, showEngineConfig, offlineModeChanged);
    }

    private void setWindowSize() {
        Configuration c = this.getConfig();
        if (c.MainWindowWidth.exists() && c.MainWindowHeight.exists()) {
            int width = (Integer)c.MainWindowWidth.get();
            int height = (Integer)c.MainWindowHeight.get();
            if (c.MainWindowPositionX.exists() && c.MainWindowPositionY.exists()) {
                int posX = (Integer)c.MainWindowPositionX.get();
                int posY = (Integer)c.MainWindowPositionY.get();
                this.setBounds(posX, posY, width, height);
            } else {
                this.setSize(width, height);
            }
        } else {
            this.pack();
        }
    }

    private void init() {
        this.doParseInstalled();
        final Future<Void> requirementsListUpdater = this.parseDatabaseAndSetList();
        Configuration.EnginePath enginePath = this.getConfig().EnginePath;
        boolean workingDirAtExecutable = false;
        File engineExe = new File("");
        if (this.getConfig().EngineExecutable.existsOrDefault()) {
            engineExe = new File(enginePath.get() + File.separator + this.getConfig().EngineExecutable);
            workingDirAtExecutable = (Boolean)this.getConfig().WorkingDirAtExecutable.get();
        }
        File workingDir = workingDirAtExecutable ? engineExe.getParentFile() : (File)enginePath.get();
        this.starter = new EngineStarter(workingDir, engineExe, this.getConfig().EngineCommandLine);
        this.installer = new Installer(enginePath, this.getConfig().DownloadPath);
        this.interactionPanel.init(this.installer, this.getConfig().RepositoryBasePath, this.maps, this.starter, new SaveInstalled(installedMapsFile));
        if (!this.installer.checkInstallDirectory()) {
            new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        requirementsListUpdater.get();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    return null;
                }

                @Override
                public void done() {
                    QuakeInjector.this.enginePathNotSetDialogue();
                }
            }.execute();
        }
    }

    private void doParseInstalled() {
        this.installedMaps.parse(installedMapsFile);
    }

    private InputStream downloadDatabase(String databaseUrl) throws IOException {
        Download d = Download.create(databaseUrl);
        d.connect();
        InputStream dl = d.getStream(null);
        return dl;
    }

    private List<Requirement> parseDatabase(InputStream database) throws IOException, SAXException {
        PackageDatabaseSolrJsonParser parser = new PackageDatabaseSolrJsonParser(this.config);
        List<Requirement> all = parser.parse(database);
        return all;
    }

    private Future<List<Requirement>> doParseDatabase() {
        final String databaseUrl = (String)this.getConfig().RepositoryDatabasePath.get();
        final SwingWorker<List<Requirement>, Void> dbParse = new SwingWorker<List<Requirement>, Void>(){
            private BufferedInputStream downloadStream;
            private File tmpFile;
            private BufferedOutputStream tmpWriteStream;
            private File cache;
            private BufferedInputStream cacheReadStream;
            private boolean updateCache = false;

            private BufferedInputStream cachedDatabaseStream() throws IOException {
                if (this.cache != null && this.cache.exists() && this.cache.canRead()) {
                    try {
                        return new BufferedInputStream(new FileInputStream(this.cache));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new IOException("cannot download package database or read local cache");
            }

            @Override
            public List<Requirement> doInBackground() throws IOException, SAXException {
                this.cache = (File)QuakeInjector.this.getConfig().LocalDatabaseFile.get();
                this.cache = this.cache.getAbsoluteFile();
                try {
                    this.downloadStream = new BufferedInputStream(QuakeInjector.this.downloadDatabase(databaseUrl));
                    this.tmpFile = File.createTempFile(this.cache.getName(), null, this.cache.getParentFile());
                    this.tmpWriteStream = new BufferedOutputStream(new FileOutputStream(this.tmpFile));
                    DumpInputStream db = new DumpInputStream(this.downloadStream, this.tmpWriteStream);
                    List<Requirement> parseResult = QuakeInjector.this.parseDatabase(db);
                    this.updateCache = true;
                    return parseResult;
                }
                catch (Exception e) {
                    this.cacheReadStream = this.cachedDatabaseStream();
                    return QuakeInjector.this.parseDatabase(this.cacheReadStream);
                }
            }

            @Override
            public void done() {
                try {
                    if (this.cacheReadStream != null) {
                        this.cacheReadStream.close();
                    }
                    if (this.tmpWriteStream != null) {
                        this.tmpWriteStream.close();
                    }
                    if (this.downloadStream != null) {
                        this.downloadStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.updateCache) {
                    if (this.cache.exists() && !this.cache.delete()) {
                        System.err.println("Couldn't delete the real cache file!");
                    }
                    if (!this.tmpFile.renameTo(this.cache)) {
                        System.err.println("Couldn't move the temporary cache file to the real cache file!");
                    }
                } else {
                    if (this.tmpFile != null && this.tmpFile.exists()) {
                        this.tmpFile.delete();
                    }
                    String msg = "Failed to fetch current database; using previously downloaded info.";
                    JOptionPane.showMessageDialog(QuakeInjector.this, msg, "Downloading failed!", 2);
                }
            }
        };
        final ProgressPopup dbpopup = new ProgressPopup("Downloading package database", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dbParse.cancel(true);
            }
        }, this);
        dbParse.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "progress") {
                    int p = (Integer)evt.getNewValue();
                    dbpopup.setProgress(p);
                } else if (evt.getPropertyName() == "state" && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                    dbpopup.close();
                }
            }
        });
        dbParse.execute();
        dbpopup.pack();
        dbpopup.setVisible(true);
        return dbParse;
    }

    private Future<List<PackageFileList>> checkForInstalledMaps() {
        File enginePath = (File)this.getConfig().EnginePath.get();
        File file = new File(zipFilesXml);
        final CheckInstalled checker = new CheckInstalled(this, (String)this.getConfig().ZipContentsDatabaseUrl.get(), ((File)this.getConfig().EnginePath.get()).toString(), this.maps, this.saveInstalled);
        final ProgressPopup dbpopup = new ProgressPopup("Checking for installed maps", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                checker.cancel(true);
            }
        }, this);
        checker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "progress") {
                    int p = (Integer)evt.getNewValue();
                    dbpopup.setProgress(p);
                } else if (evt.getPropertyName() == "state" && evt.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                    dbpopup.close();
                }
            }
        });
        checker.execute();
        dbpopup.pack();
        dbpopup.setVisible(true);
        return checker;
    }

    void setInstalledStatus(List<PackageFileList> packages) {
        for (PackageFileList l : packages) {
            this.maps.setInstalled(l);
        }
        this.maps.notifyChangeListeners();
    }

    private Future<Void> parseDatabaseAndSetList() {
        final Future<List<Requirement>> dbParse = this.doParseDatabase();
        SwingWorker<Void, Void> waitForInstalledMapsAndDb = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws Exception {
                QuakeInjector.this.installedMaps.get();
                dbParse.get();
                return null;
            }

            @Override
            public void done() {
                List packages = null;
                try {
                    packages = (List)dbParse.get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeExecutionException("parsing database", e);
                }
                catch (ExecutionException e) {
                    String ERROR_MESSAGE = "Database parsing failed!";
                    Throwable err = e.getCause();
                    Object msg = err.getMessage();
                    try {
                        throw err;
                    }
                    catch (UnknownHostException exc) {
                        msg = "Couldn't establish connection to the server (" + err.getMessage() + ").";
                        QuakeInjector.this.offline.set(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(QuakeInjector.this, ERROR_MESSAGE + " " + (String)msg, ERROR_MESSAGE, 0);
                    return;
                }
                QuakeInjector.this.maps.setRequirements(packages);
                System.out.println("Setting Requirements");
                try {
                    QuakeInjector.this.setInstalledStatus(QuakeInjector.this.installedMaps.get());
                }
                catch (InterruptedException e) {
                    System.err.println("Interrupted while getting installed maps" + e);
                    e.printStackTrace();
                }
                catch (ExecutionException err) {
                    QuakeInjector.this.maps.notifyChangeListeners();
                    try {
                        throw err.getCause();
                    }
                    catch (InstalledPackages.NoInstalledPackagesFileException e) {
                        System.err.println(e.getMessage());
                    }
                    catch (Throwable e) {
                        String ERROR_MESSAGE = "Reading installed maps failed!";
                        JOptionPane.showMessageDialog(QuakeInjector.this, ERROR_MESSAGE + " " + e.getMessage(), ERROR_MESSAGE, 0);
                    }
                }
            }
        };
        waitForInstalledMapsAndDb.execute();
        return waitForInstalledMapsAndDb;
    }

    private void showEngineConfig(boolean rogueInstalled, boolean hipnoticInstalled) {
        final EngineConfigDialog d = new EngineConfigDialog(this, this.getConfig().EnginePath, this.getConfig().EngineExecutable, this.getConfig().WorkingDirAtExecutable, this.getConfig().DownloadPath, this.getConfig().EngineCommandLine, this.getConfig().RogueInstalled, this.getConfig().HipnoticInstalled, this.getConfig().uiTheme);
        d.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    QuakeInjector.this.saveEngineConfig(d.getEnginePath(), d.getEngineExecutable(), d.getWorkingDirAtExecutable(), d.getDownloadPath(), d.getCommandline(), d.getRogueInstalled(), d.getHipnoticInstalled(), d.getUiTheme());
                }
                catch (IOException err) {
                    QuakeInjector.this.savingFailedDialogue(err);
                }
            }
        });
        d.pack();
        d.setLocationRelativeTo(this);
        d.setVisible(true);
    }

    private void savingFailedDialogue(IOException e) {
        String msg = "Saving the configuration file failed: " + e.getMessage() + "\nThe directory is probably read-only and cannot be set writable automatically (Vista/Win7 bug), try to set write permissions manually.";
        JOptionPane.showMessageDialog(this, msg, "Saving configuration failed!", 0);
    }

    private void saveEngineConfig(File enginePath, File engineExecutable, boolean workingDirAtExecutable, File downloadPath, String commandline, boolean rogueInstalled, boolean hipnoticInstalled, UIThemeOption uiThemeOption) throws IOException {
        Configuration c = this.getConfig();
        c.EnginePath.set(enginePath);
        c.EngineExecutable.set(RelativePath.getRelativePath(enginePath, engineExecutable));
        c.WorkingDirAtExecutable.set(workingDirAtExecutable);
        c.EngineCommandLine.set(commandline);
        c.RogueInstalled.set(rogueInstalled);
        c.HipnoticInstalled.set(hipnoticInstalled);
        c.DownloadPath.set(downloadPath);
        c.uiTheme.set(uiThemeOption);
        File workingDir = workingDirAtExecutable ? engineExecutable.getParentFile() : enginePath;
        this.setEngineConfig(workingDir, engineExecutable, this.getConfig().EngineCommandLine, rogueInstalled, hipnoticInstalled);
        try {
            c.write();
        }
        catch (IOException e) {
            File dir = configFile.getAbsoluteFile().getParentFile();
            System.out.println("Trying to set directory (" + dir + ") writable..");
            try {
                dir.setWritable(true);
            }
            catch (SecurityException securityError) {
                System.out.println("Couldn't set writable: " + securityError);
            }
            c.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEngineConfig(File workingDir, File engineExecutable, Configuration.EngineCommandLine commandline, boolean rogueInstalled, boolean hipnoticInstalled) {
        this.starter.setWorkingDirectory(workingDir);
        this.starter.setQuakeApplication(engineExecutable);
        this.starter.setQuakeCommandline(commandline);
        this.maps.get("rogue").setInstalled(rogueInstalled);
        this.maps.get("hipnotic").setInstalled(hipnoticInstalled);
        try {
            RequirementList requirementList = this.maps;
            synchronized (requirementList) {
                this.saveInstalled.write(this.maps);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addMainPane(Container panel) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        final PackageTable table = new PackageTable(this.maplist);
        this.maplist.size(table);
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new BoxLayout(filterPanel, 2));
        JLabel filterText = new JLabel("Filter: ", 11);
        filterPanel.add(filterText);
        filterPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        final JButton clearFilter = new JButton("Clear");
        clearFilter.setEnabled(false);
        final JTextField filter = new JTextField();
        filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            private void filter() {
                ((DefaultRowSorter)table.getRowSorter()).setRowFilter(QuakeInjector.this.maplist.filter(filter.getText()));
                if (filter.getText().equals("")) {
                    clearFilter.setEnabled(false);
                } else {
                    clearFilter.setEnabled(true);
                }
            }
        });
        filterText.setLabelFor(filter);
        filterPanel.add(filter);
        mainPanel.add((Component)filterPanel, new GridBagConstraints(){
            {
                this.anchor = 21;
                this.fill = 2;
                this.weightx = 1.0;
                this.weighty = 0.0;
            }
        });
        clearFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                filter.setText("");
            }
        });
        filterPanel.add((Component)clearFilter, new GridBagConstraints(){
            {
                this.anchor = 22;
            }
        });
        JButton randomMapButton = new JButton("Install Random Map");
        randomMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int mapTableRowIdx = new Random().nextInt(QuakeInjector.this.maplist.getRowCount());
                int mapListIdx = ((DefaultRowSorter)table.getRowSorter()).convertRowIndexToModel(mapTableRowIdx);
                Package map = QuakeInjector.this.maplist.getPackage(mapListIdx);
                if (!QuakeInjector.this.maplist.isPackageInstalled(map)) {
                    QuakeInjector.this.interactionPanel.install(map, false);
                }
                table.setRowSelectionInterval(mapTableRowIdx, mapTableRowIdx);
                table.scrollRectToVisible(new Rectangle(table.getCellRect(mapTableRowIdx, 0, true)));
            }
        });
        filterPanel.add((Component)randomMapButton, new GridBagConstraints(){
            {
                this.anchor = 22;
            }
        });
        JScrollPane scrollPane = new JScrollPane(table);
        mainPanel.add((Component)scrollPane, new GridBagConstraints(){
            {
                this.anchor = 10;
                this.fill = 1;
                this.gridx = 0;
                this.gridy = 1;
                this.gridwidth = 1;
                this.gridheight = 1;
                this.weightx = 1.0;
                this.weighty = 1.0;
            }
        });
        InstallQueuePanel installQueue = new InstallQueuePanel();
        this.interactionPanel = new PackageInteractionPanel(this, installQueue);
        JPanel infoPanel = new JPanel(new GridBagLayout());
        Configuration config = this.getConfig();
        PackageDetailPanel details = new PackageDetailPanel(config);
        infoPanel.add((Component)details, new GridBagConstraints(){
            {
                this.anchor = 19;
                this.fill = 1;
                this.weightx = 1.0;
                this.weighty = 1.0;
            }
        });
        infoPanel.add((Component)this.interactionPanel, new GridBagConstraints(){
            {
                this.gridy = 1;
                this.fill = 1;
                this.weightx = 1.0;
            }
        });
        JScrollPane queueScroll = new JScrollPane(installQueue);
        infoPanel.add((Component)queueScroll, new GridBagConstraints(){
            {
                this.anchor = 20;
                this.fill = 1;
                this.gridy = 3;
                this.weightx = 1.0;
                this.weighty = 1.0;
            }
        });
        JSplitPane infoSplit = new JSplitPane(0, infoPanel, queueScroll);
        infoSplit.setOneTouchExpandable(true);
        infoSplit.setResizeWeight(1.0);
        infoSplit.setContinuousLayout(true);
        infoSplit.setDividerLocation(600);
        infoSplit.setMinimumSize(new Dimension(400, 600));
        PackageListSelectionHandler selectionHandler = new PackageListSelectionHandler(this.maplist, table);
        table.getSelectionModel().addListSelectionListener(selectionHandler);
        selectionHandler.addSelectionListener(this.interactionPanel);
        selectionHandler.addSelectionListener(details);
        JSplitPane splitPane = new JSplitPane(1, mainPanel, infoSplit);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(1.0);
        splitPane.setContinuousLayout(true);
        splitPane.setMinimumSize(new Dimension(450, 300));
        panel.add(splitPane);
    }

    private void display() {
        this.setVisible(true);
        if (this.getConfig().MainWindowState.exists()) {
            int state = (Integer)this.getConfig().MainWindowState.get();
            this.setExtendedState(state);
            System.out.println("Setting window state: " + state);
        }
    }

    private Configuration getConfig() {
        if (this.config == null) {
            throw new RuntimeException("Config not initialised!");
        }
        return this.config;
    }

    public boolean enginePathNotSetDialogue() {
        String msg = "Quake directory is not set correctly.\nIt needs to be set before trying to install (or play).";
        Object[] options = new Object[]{"Open Engine Configuration", "Cancel"};
        int openEngineConfig = JOptionPane.showOptionDialog(null, msg, "Quake directory incorrect", 0, 0, null, options, options[0]);
        if (openEngineConfig == 0) {
            this.showEngineConfig(this.maps.get("rogue").isInstalled(), this.maps.get("hipnotic").isInstalled());
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        if (null == System.getenv("_JAVA_OPTIONS") || !System.getenv("_JAVA_OPTIONS").contains("useSystemAAFontSettings")) {
            System.setProperty("awt.useSystemAAFontSettings", "on");
        }
        System.setProperty("http.agent", "Quakeinjector-" + BuildCommit.getBuildCommit());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QuakeInjector qs = new QuakeInjector();
                qs.display();
                qs.init();
            }
        });
    }

    private static List<Image> createIconList(int[] iconSizes, String iconUrl, String sizeToken) {
        ArrayList<Image> icons = new ArrayList<Image>(iconSizes.length);
        for (int size : iconSizes) {
            String path = iconUrl.replace(sizeToken, Integer.toString(size));
            try {
                ImageIcon icon = Utils.createImageIcon(path, "Icon" + size);
                icons.add(icon.getImage());
            }
            catch (IOException e) {
                System.err.println("WARNING: Couldn't load icon file " + path);
            }
        }
        return icons;
    }

    private class QuakeInjectorWindowListener
    extends WindowAdapter {
        private QuakeInjectorWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (QuakeInjector.this.installer.working()) {
                String msg = "There are maps left in the install queue. Wait until they are finished installing?";
                Object[] options = new Object[]{"Wait", "Close immediately"};
                int optionDialog = JOptionPane.showOptionDialog(null, msg, "Maps still installing", 0, 2, null, options, options[0]);
                if (optionDialog == 0) {
                    QuakeInjector.this.setDefaultCloseOperation(0);
                    return;
                }
                QuakeInjector.this.installer.cancelAll();
                QuakeInjector.this.setDefaultCloseOperation(3);
            }
            this.windowClosed(e);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            Configuration config = QuakeInjector.this.getConfig();
            Rectangle bounds = QuakeInjector.this.getBounds();
            config.MainWindowPositionX.set((int)bounds.getX());
            config.MainWindowPositionY.set((int)bounds.getY());
            config.MainWindowWidth.set((int)bounds.getWidth());
            config.MainWindowHeight.set((int)bounds.getHeight());
            config.MainWindowState.set(QuakeInjector.this.getExtendedState());
            try {
                config.write();
            }
            catch (IOException err) {
                QuakeInjector.this.savingFailedDialogue(err);
            }
            System.exit(0);
        }
    }
}

