/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.FileInfo;
import de.haukerehfeld.quakeinjector.InstalledPackageList;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.Requirement;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class SaveInstalled {
    private final File file;

    public SaveInstalled(File file) {
        this.file = file;
    }

    private OutputStream getOutputStream() throws IOException {
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        return new BufferedOutputStream(new FileOutputStream(this.file));
    }

    private InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public void write(Iterable<? extends Requirement> list) throws IOException {
        OutputStream out = this.getOutputStream();
        new InstalledPackageList().write(out, list);
        out.close();
    }

    public void write(Map<String, Iterable<FileInfo>> files) throws IOException {
        OutputStream out = this.getOutputStream();
        new InstalledPackageList().write(out, files);
        out.close();
    }

    public List<PackageFileList> read() throws IOException {
        InputStream in = this.getInputStream();
        List<PackageFileList> result = new InstalledPackageList().read(in);
        in.close();
        return result;
    }
}

