/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector;

import de.haukerehfeld.quakeinjector.FileInfo;
import de.haukerehfeld.quakeinjector.PackageFileList;
import de.haukerehfeld.quakeinjector.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.SwingWorker;

public class UninstallWorker
extends SwingWorker<Void, Void> {
    private String baseDirectory;
    private PackageFileList files;

    public UninstallWorker(PackageFileList files, String baseDirectory) {
        this.files = files;
        this.baseDirectory = baseDirectory;
    }

    @Override
    public Void doInBackground() {
        this.uninstall(this.files);
        return null;
    }

    public void uninstall(PackageFileList files) {
        int fileCount = files.size();
        int i = 1;
        Iterator<FileInfo> it = files.descendingIterator();
        while (it.hasNext()) {
            File f;
            block7: {
                FileInfo file = it.next();
                f = new File(this.baseDirectory + File.separator + file.getName());
                long supposedCrc = file.getChecksum();
                String skipMsg = "Couldn't check CRC for " + f + ", deleting...";
                if (supposedCrc != 0L) {
                    try {
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
                        long crc = Utils.getCrc32(in, null);
                        in.close();
                        if (crc != supposedCrc) {
                            System.err.println("CRC for " + f + " didn't match, not deleting");
                            continue;
                        }
                        break block7;
                    }
                    catch (IOException e) {
                        System.err.println(skipMsg);
                        break block7;
                    }
                }
                System.err.println(skipMsg);
            }
            if (!f.delete()) {
                System.out.println("Couldn't delete " + f);
            } else {
                System.out.println("Deleted file " + f);
            }
            int progress = i * 100 / fileCount;
            this.setProgress(progress);
            ++i;
        }
    }

    @Override
    public void done() {
    }
}

