/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class OkayCancelApplyPanel
extends JPanel {
    private static final Insets LEFTBORDER = new Insets(7, 7, 7, 7);
    private static final Insets OTHERBORDER = new Insets(7, 0, 7, 7);
    private final JButton okay;
    private final JButton cancel;
    private final JButton apply;

    public OkayCancelApplyPanel(JButton okay, JButton cancel, JButton apply, boolean useApply) {
        this.setLayout(new GridBagLayout());
        this.okay = okay;
        this.cancel = cancel;
        this.apply = apply;
        ArrayList<JComponent> components = new ArrayList<JComponent>(3);
        components.add(okay);
        if (cancel != null) {
            components.add(cancel);
        }
        if (apply != null) {
            apply.setEnabled(false);
            components.add(apply);
        }
        OkayCancelApplyPanel.addRow(this, 0, components);
    }

    public void setApplyEnabled(boolean enabled) {
        this.apply.setEnabled(enabled);
    }

    public static void addRow(Container container, final int row, List<JComponent> components) {
        container.add(Box.createHorizontalGlue(), new LeftConstraints());
        int col = 1;
        for (JComponent c : components) {
            final int col_ = col++;
            container.add((Component)c, new RightConstraints(){
                {
                    this.gridx = col_;
                    this.gridy = row;
                }
            });
        }
    }

    static class LeftConstraints
    extends GridBagConstraints {
        LeftConstraints() {
            this.insets = LEFTBORDER;
            this.gridx = 0;
            this.weightx = 1.0;
        }
    }

    static class RightConstraints
    extends GridBagConstraints {
        RightConstraints() {
            this.insets = OTHERBORDER;
            this.anchor = 22;
            this.fill = 0;
        }
    }
}

