/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class ProgressPopup
extends JDialog {
    private JProgressBar progress;
    private JButton cancelButton;
    private String description;

    public ProgressPopup(String description, ActionListener cancel, JFrame frame) {
        super(frame, description, true);
        this.setLocationRelativeTo(frame);
        this.description = description;
        this.setLayout(new GridBagLayout());
        this.progress = new JProgressBar();
        this.progress.setString(description);
        this.progress.setValue(0);
        this.progress.setIndeterminate(true);
        this.progress.setStringPainted(true);
        this.add((Component)this.progress, new GridBagConstraints(){
            {
                this.anchor = 10;
                this.gridx = 0;
                this.fill = 1;
                this.weightx = 1.0;
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(cancel);
        this.add((Component)cancelButton, new GridBagConstraints(){
            {
                this.anchor = 10;
                this.fill = 1;
                this.gridy = 1;
            }
        });
    }

    public void setProgress(int percent) {
        this.progress.setIndeterminate(false);
        this.progress.setValue(percent);
        this.progress.setString(ProgressPopup.progressString(this.description, percent));
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static String progressString(String description, String status) {
        return description + ": " + status;
    }

    public static String progressString(String description, int progress) {
        return ProgressPopup.progressString(description, progress + "%");
    }
}

