/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector.gui;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.theme.DarculaTheme;
import com.github.weisj.darklaf.theme.IntelliJTheme;
import com.github.weisj.darklaf.theme.SolarizedDarkTheme;
import com.github.weisj.darklaf.theme.SolarizedLightTheme;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import javax.swing.UIManager;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum UIThemeOption {
    SYSTEM("system", "Follow System Preferences"){

        @Override
        public void init() {
            LafManager.installTheme((PreferredThemeStyle)LafManager.getPreferredThemeStyle());
        }
    }
    ,
    LIGHT("light", "Light"){

        @Override
        public void init() {
            LafManager.installTheme((Theme)new IntelliJTheme());
        }
    }
    ,
    DARCULA("darcula", "Darcula"){

        @Override
        public void init() {
            LafManager.installTheme((Theme)new DarculaTheme());
        }
    }
    ,
    SOLARIZED_LIGHT("solarizedlight", "Solarized Light"){

        @Override
        public void init() {
            LafManager.installTheme((Theme)new SolarizedLightTheme());
        }
    }
    ,
    SOLARIZED_DARK("solarizeddark", "Solarized Dark"){

        @Override
        public void init() {
            LafManager.installTheme((Theme)new SolarizedDarkTheme());
        }
    }
    ,
    LEGACY("legacy", "Legacy"){

        @Override
        public void init() {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private final String code;
    private final String title;

    private UIThemeOption(String code, String title) {
        this.code = code;
        this.title = title;
    }

    public abstract void init();

    public String getCode() {
        return this.code;
    }

    public String getTitle() {
        return this.title;
    }

    public static UIThemeOption getByCode(String code) {
        for (UIThemeOption t : UIThemeOption.values()) {
            if (!t.getCode().equals(code)) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return this.title;
    }
}

