/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector.packagelist.model;

import de.haukerehfeld.quakeinjector.Package;
import java.util.Arrays;
import java.util.Date;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Column {
    INSTALLED(""){

        @Override
        public Object getData(Package p) {
            return p.isInstalled();
        }

        @Override
        public Class<? extends Object> getColumnClass() {
            return Boolean.class;
        }
    }
    ,
    NAME("Name"){

        @Override
        public Object getData(Package p) {
            return p.getId();
        }

        @Override
        public Class<? extends Object> getColumnClass() {
            return String.class;
        }
    }
    ,
    TITLE("Title"){

        @Override
        public Object getData(Package p) {
            return p.getTitle();
        }

        @Override
        public Class<? extends Object> getColumnClass() {
            return String.class;
        }
    }
    ,
    AUTHOR("Author"){

        @Override
        public Object getData(Package p) {
            return p.getAuthor();
        }

        @Override
        public Class<? extends Object> getColumnClass() {
            return String.class;
        }
    }
    ,
    RELEASEDATE("Released"){

        @Override
        public Object getData(Package p) {
            return p.getDate();
        }

        @Override
        public Class<? extends Object> getColumnClass() {
            return Date.class;
        }
    }
    ,
    SIZE("Size (MB)"){

        @Override
        public Object getData(Package p) {
            return (double)Math.round(10.0 * (double)p.getSize() / 1024.0) / 10.0;
        }

        @Override
        public Class<? extends Object> getColumnClass() {
            return Integer.class;
        }
    };

    public String header;

    private Column(String header) {
        this.header = header;
    }

    public abstract Object getData(Package var1);

    public abstract Class<? extends Object> getColumnClass();

    public static int getColumnNumber(Column c) {
        return Arrays.binarySearch((Object[])Column.values(), (Object)c);
    }

    public static Column getColumn(int column) {
        Column[] values = Column.values();
        if (values.length <= column) {
            throw new RuntimeException("Unknown Column");
        }
        return values[column];
    }

    public static int count() {
        return Column.values().length;
    }
}

