/*
 * Decompiled with CFR 0.152.
 */
package de.haukerehfeld.quakeinjector.repackage;

import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;

public class ExtractMapping {
    private final Map<String, String> map = new TreeMap<String, String>((a, b) -> a.length() != b.length() ? Integer.compare(b.length(), a.length()) : a.compareTo((String)b));

    private String makeRelative(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("{base}")) {
            path = path.substring("{base}".length());
        }
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path;
    }

    public void addMapping(String from, String to) {
        this.map.put(this.makeRelative(from), this.makeRelative(to));
    }

    public String remap(String originalPathString) {
        originalPathString = this.makeRelative(originalPathString);
        Path originalPath = Path.of(originalPathString, new String[0]);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            if (!originalPath.startsWith(entry.getKey()) && !entry.getKey().isEmpty()) continue;
            if (entry.getValue() == null) {
                return null;
            }
            Path relativePath = Path.of(entry.getKey(), new String[0]).relativize(originalPath);
            if (relativePath.toString().isEmpty()) {
                return Path.of(entry.getValue(), new String[0]).toString();
            }
            return Path.of(entry.getValue(), relativePath.toString()).toString();
        }
        return Path.of(originalPathString, new String[0]).toString();
    }
}

