@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%"=="" @echo off
@rem ##########################################################################
@rem
@rem  QuakeInjector startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%"=="" set DIRNAME=.
@rem This is normally unused
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and QUAKE_INJECTOR_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if %ERRORLEVEL% equ 0 goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\QuakeInjector-alpha08.jar;%APP_HOME%\lib\BrowserLauncher2-1.3.jar;%APP_HOME%\lib\jackson-annotations-2.13.3.jar;%APP_HOME%\lib\jackson-core-2.13.3.jar;%APP_HOME%\lib\jackson-databind-2.13.3.jar;%APP_HOME%\lib\commons-compress-1.27.1.jar;%APP_HOME%\lib\darklaf-core-2.7.3.jar;%APP_HOME%\lib\commons-codec-1.17.1.jar;%APP_HOME%\lib\commons-io-2.16.1.jar;%APP_HOME%\lib\commons-lang3-3.16.0.jar;%APP_HOME%\lib\darklaf-windows-2.7.3.jar;%APP_HOME%\lib\darklaf-macos-2.7.3.jar;%APP_HOME%\lib\darklaf-theme-2.7.3.jar;%APP_HOME%\lib\darklaf-property-loader-2.7.3.jar;%APP_HOME%\lib\darklaf-native-utils-2.7.3.jar;%APP_HOME%\lib\darklaf-utils-2.7.3.jar;%APP_HOME%\lib\darklaf-platform-base-2.7.3.jar;%APP_HOME%\lib\swing-extensions-laf-support-0.1.3.jar;%APP_HOME%\lib\svgSalamander-1.1.2.4.jar;%APP_HOME%\lib\swing-extensions-visual-padding-0.1.3.jar;%APP_HOME%\lib\annotations-16.0.2.jar


@rem Execute QuakeInjector
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %QUAKE_INJECTOR_OPTS%  -classpath "%CLASSPATH%" de.haukerehfeld.quakeinjector.QuakeInjector %*

:end
@rem End local scope for the variables with windows NT shell
if %ERRORLEVEL% equ 0 goto mainEnd

:fail
rem Set variable QUAKE_INJECTOR_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
set EXIT_CODE=%ERRORLEVEL%
if %EXIT_CODE% equ 0 set EXIT_CODE=1
if not ""=="%QUAKE_INJECTOR_EXIT_CONSOLE%" exit %EXIT_CODE%
exit /b %EXIT_CODE%

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
